% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate.R
\name{coalesce_compatible}
\alias{coalesce_compatible}
\title{Coalesce all compatible rows of a data frame}
\usage{
coalesce_compatible(.data)
}
\arguments{
\item{.data}{data frame to consolidate}
}
\value{
A tibble with the missing observations coalesced for compatible rows
}
\description{
This function identifies and coalesces
all compatible rows in a data frame.
Compatible rows are defined as those rows where
all present elements are equal,
allowing for equality where one row has an element present
and the other is missing the observation.
}
\examples{
eg1 <- tibble::tribble(
~x, ~y, ~z,
"a", "b", NA,
"a", "b", "c",
"j", "k", NA,
NA, "k", "l")
coalesce_compatible(eg1)
}
