% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot2est_lm.R
\name{lm2boot_out}
\alias{lm2boot_out}
\title{Bootstrap Estimates for \code{lm}
Outputs}
\usage{
lm2boot_out(outputs, R = 100, seed = NULL, progress = TRUE)
}
\arguments{
\item{outputs}{A list of \code{lm} class
objects, or the output of \code{\link[=lm2list]{lm2list()}}
(i.e., an \code{lm_list}-class object).}

\item{R}{The number of bootstrap
samples. Default is 100.}

\item{seed}{The seed for the
bootstrapping. Default is \code{NULL} and
seed is not set.}

\item{progress}{Whether progress will
be displayed. Default is \code{TRUE}.}
}
\value{
A \code{boot_out}-class object
that can be used for the \code{boot_out}
argument of \code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
related functions for forming
bootstrapping confidence intervals.
The object is a list with the number
of elements equal to the number of
bootstrap samples. Each element is a
list of the parameter estimates and
sample variances and covariances of
the variables in each bootstrap
sample.
}
\description{
Generate bootstrap
estimates for models in a list of
'lm' outputs.
}
\details{
This function is for
advanced users. \code{\link[=do_boot]{do_boot()}} is a
function users should try first
because \code{\link[=do_boot]{do_boot()}} has a general
interface for input-specific
functions like this one.

It does nonparametric bootstrapping
to generate bootstrap estimates of
the regression coefficients in the
regression models of a list of \code{\link[=lm]{lm()}}
outputs, or an \code{lm_list}-class object
created by \code{\link[=lm2list]{lm2list()}}. The stored
estimates can be used by
\code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
related functions in forming
bootstrapping confidence intervals
for effects such as indirect effect
and conditional indirect effects.

This approach removes the need to
repeat bootstrapping in each call to
\code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
related functions. It also ensures
that the same set of bootstrap
samples is used in all subsequent
analyses.
}
\examples{

data(data_med_mod_ab1)
dat <- data_med_mod_ab1
lm_m <- lm(m ~ x*w + c1 + c2, dat)
lm_y <- lm(y ~ m*w + x + c1 + c2, dat)
lm_out <- lm2list(lm_m, lm_y)
# In real research, R should be 2000 or even 5000
# In real research, no need to set progress to FALSE
# Progress is displayed by default.
lm_boot_out <- lm2boot_out(lm_out, R = 100, seed = 1234,
                           progress = FALSE)
out <- cond_indirect_effects(wlevels = "w",
                             x = "x",
                             y = "y",
                             m = "m",
                             fit = lm_out,
                             boot_ci = TRUE,
                             boot_out = lm_boot_out)
out

}
\seealso{
\code{\link[=do_boot]{do_boot()}}, the general
purpose function that users should
try first before using this function.
}
