% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_autographr.R
\name{autographing}
\alias{autographing}
\alias{autographr}
\alias{autographs}
\alias{autographd}
\title{Quickly graph networks with sensible defaults}
\source{
http://blog.schochastics.net/post/animating-network-evolutions-with-gganimate/

http://blog.schochastics.net/post/animating-network-evolutions-with-gganimate/
}
\usage{
autographr(
  .data,
  layout = NULL,
  labels = TRUE,
  node_color = NULL,
  node_shape = NULL,
  node_size = NULL,
  edge_color = NULL,
  ...
)

autographs(netlist, ...)

autographd(
  tlist,
  keep_isolates = TRUE,
  layout = "stress",
  labels = TRUE,
  node_color = NULL,
  node_shape = NULL,
  node_size = NULL,
  edge_color = NULL
)
}
\arguments{
\item{.data}{A manynet-consistent object.}

\item{layout}{An igraph, ggraph, or manynet layout algorithm,
currently defaults to 'stress'.}

\item{labels}{Logical, whether to print node names
as labels if present.}

\item{node_color}{Node variable in quotation marks to be used for
coloring the nodes. It is easiest if this is added as a node attribute to
the graph before plotting.}

\item{node_shape}{Character string in quotation marks referring to the name
of a node attribute already present in the graph to be used for the shapes
of the nodes.
Shapes follow the ordering "circle", "square", "triangle",
so this aesthetic should be used for a variable with only a few categories.}

\item{node_size}{Node variable in quotation marks to be used for
the size of the nodes.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all node-related statistics prior
to using this function.}

\item{edge_color}{Tie variable in quotation marks to be used for
coloring the nodes. It is easiest if this is added as an edge or tie attribute
to the graph before plotting.}

\item{...}{Extra arguments to pass on to \code{autographr()}/\code{ggraph()}/\code{ggplot()}.}

\item{netlist}{A list of manynet-compatible networks.}

\item{tlist}{The same migraph-compatible network listed according to
a time attribute, waves, or slices.}

\item{keep_isolates}{Would you like to remove vertices that do not have
any adjacent edges in each frame?
TRUE by default.
If FALSE, deletes isolated vertices in each frame.}
}
\value{
A ggplot2::ggplot() object.
}
\description{
The aim of this function is to provide users with a quick and easy
graphing function that makes best use of the data,
whatever its composition. Users can also tailor the plot according to their
preferences regarding node size, colour, and shape. The function also supports
visualisation of network measures such as centrality.
}
\section{Functions}{
\itemize{
\item \code{autographr()}: Graphs a network with sensible defaults

\item \code{autographs()}: Graphs a list of networks
with sensible defaults

\item \code{autographd()}: Graphs an dynamic (animated) network
with sensible defaults

}}
\examples{
#ison_adolescents \%>\% 
#   mutate(shape = rep(c("circle", "square"), times = 4),
#          color = rep(c("blue", "red"), times = 4)) \%>\%
#  autographr(node_shape = "shape", node_color = "color")
#autographr(ison_karateka, node_size = 8)
#autographs(to_egos(ison_adolescents))
#ison_adolescents \%>\%
# mutate_ties(year = sample(1995:1998, 10, replace = TRUE)) \%>\%
# to_waves(attribute = "year") \%>\%
# autographd()
#ison_adolescents \%>\%
# mutate(shape = rep(c("circle", "square"), times = 4),
#        color = rep(c("blue", "red"), times = 4),
#        size = sample(4:16, 8, replace = TRUE)) \%>\%
# mutate_ties(year = sample(1995:1998, 10, replace = TRUE),
#        e_color = sample(c("yellow", "green"), 10, replace = TRUE)) \%>\%
# to_waves(attribute = "year") \%>\%
# autographd(keep_isolates = FALSE, layout = "circle", node_shape = "shape",
#            node_color = "color", node_size =  "size",
#            edge_color = "e_color")
}
\seealso{
Other mapping: 
\code{\link{attributes}()},
\code{\link{is}()},
\code{\link{partition_layouts}},
\code{\link{properties}}
}
\concept{mapping}
