% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformed.R
\name{to_scope}
\alias{to_scope}
\alias{to_giant}
\alias{to_no_isolates}
\alias{to_subgraph}
\alias{to_blocks}
\title{Modifying networks scope}
\usage{
to_giant(.data)

to_no_isolates(.data)

to_subgraph(.data, ...)

to_blocks(.data, membership, FUN = mean)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{...}{Arguments passed on to dplyr::filter}

\item{membership}{A vector of partition memberships.}

\item{FUN}{A function for summarising block content.
By default \code{mean}.
Other recommended options include \code{median}, \code{sum},
\code{min} or \code{max}.}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions offer tools for transforming manynet-consistent objects
(matrices, igraph, tidygraph, or network objects).
Transforming means that the returned object may have different dimensions
than the original object.
\itemize{
\item \code{to_giant()} scopes a network into one including only the main component and no smaller components or isolates.
\item \code{to_no_isolates()} scopes a network into one excluding all nodes without ties
\item \code{to_subgraph()} scopes a network into a subgraph by filtering on some node-related logical statement.
\item \code{to_blocks()} reduces a network to ties between a given partition membership vector.
}
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrrr}{
    \tab data.frame \tab igraph \tab list \tab matrix \tab network \tab tbl_graph \cr
   to_blocks \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_giant \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_no_isolates \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_subgraph \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
}
}
\section{\code{to_blocks()}}{

Reduced graphs provide summary representations of network structures
by collapsing groups of connected nodes into single nodes
while preserving the topology of the original structures.
}

\examples{
ison_adolescents \%>\%
  mutate_ties(wave = sample(1995:1998, 10, replace = TRUE)) \%>\%
  to_waves(attribute = "wave") \%>\%
  to_no_isolates()
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{correlation}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}}
}
\concept{modifications}
