% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cluster.R
\name{model_cluster}
\alias{model_cluster}
\alias{cluster_hierarchical}
\alias{cluster_concor}
\title{Methods for equivalence clustering}
\usage{
cluster_hierarchical(census, distance)

cluster_concor(.data, census)
}
\arguments{
\item{census}{A matrix returned by a \verb{node_by_*()} function.}

\item{distance}{Character string indicating which distance metric
to pass on to \code{stats::dist}.
By default \code{"euclidean"}, but other options include
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"}, and \code{"minkowski"}.
Fewer, identifiable letters, e.g. \code{"e"} for Euclidean, is sufficient.}

\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions are used to cluster some census object:
\itemize{
\item \code{cluster_hierarchical()} returns a hierarchical clustering object
created by \code{stats::hclust()}.
\item \code{cluster_concor()} returns a hierarchical clustering object
created from a convergence of correlations procedure (CONCOR).
}

These functions are not intended to be called directly,
but are called within \code{node_equivalence()} and related functions.
They are exported and listed here to provide more detailed documentation.
}
\section{CONCOR}{


First a matrix of Pearson correlation coefficients between each pair of nodes
profiles in the given census is created.
Then, again, we find the correlations of this square, symmetric matrix,
and continue to do this iteratively until each entry is either \code{1} or \code{-1}.
These values are used to split the data into two partitions,
with members either holding the values \code{1} or \code{-1}.
This procedure from census to convergence is then repeated within each block,
allowing further partitions to be found.
Unlike UCINET, partitions are continued until there are single members in
each partition.
Then a distance matrix is constructed from records of in which partition phase
nodes were separated,
and this is given to \code{stats::hclust()} so that dendrograms etc can be returned.
}

\references{
Breiger, Ronald L., Scott A. Boorman, and Phipps Arabie. 1975.
"An Algorithm for Clustering Relational Data with Applications to
Social Network Analysis and Comparison with Multidimensional Scaling".
\emph{Journal of Mathematical Psychology}, 12: 328-83.
\doi{10.1016/0022-2496(75)90028-0}.
}
