% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_maple.R
\name{fit_maple}
\alias{fit_maple}
\title{Fit Maple multi-sample Bayesian spatial mixture model}
\usage{
fit_maple(
  seurat_obj,
  K,
  emb = "PCs",
  n_dim = 8,
  covars = NULL,
  MCAR = FALSE,
  CAR = FALSE,
  smooth = TRUE,
  r = 3,
  nsim = 2000,
  burn = 1000,
  z_init = NULL
)
}
\arguments{
\item{seurat_obj}{An integrated Seurat object.}

\item{K}{The number of sub-populations to infer. Each should be present in each sample.}

\item{emb}{The cell spot embedding to use. Either one of "PCs", "scGNN", "harmony", "HVGs", or "SVGs".}

\item{n_dim}{The number of dimensions to use.}

\item{covars}{Column names of Seurat meta data to use as covariates. If none specified, will fit a global intercept and sample-indicator model for cell type membership probabilities.}

\item{MCAR}{Logical. Include multivariate CAR random intercepts in gene expression model?}

\item{CAR}{Logical. Include univariate CAR random intercepts in multinomial gene expression model?}

\item{smooth}{Logical. Use manual spatial smoothing controlled by r parameter?}

\item{r}{Spatial smoothing parameter for if smooth == TRUE. Should be greater than 0 with larger values enforcing stronger prior spatial association.}

\item{nsim}{Number of total MCMC iterations to conduct.}

\item{burn}{Number of initial MCMC iterations to discard as burn in. The number of saved iterations is nsim-burn.}

\item{z_init}{Initialized cluster allocation vector to aid in MCMC convergence. If NULL z_init will be set using hierarchical clustering.}
}
\value{
A list of MCMC samples, including the MAP estimate of cluster indicators (z)
}
\description{
This function allows you to detect sub-populations and explain membership with relevant covariates in multi-sample spatial transcriptomics experiments.
}
\examples{
\dontrun{
brain1 <- LoadData("stxBrain", type = "anterior1")
brain2 <- LoadData("stxBrain", type = "anterior2")
brain1 <- SCTransform(brain1, assay = "Spatial", verbose = FALSE)
brain2 <- SCTransform(brain2, assay = "Spatial", verbose = FALSE)
brain <- merge(brain1,brain2)
DefaultAssay(brain) <- "SCT"
VariableFeatures(brain) <- c(VariableFeatures(brain1),VariableFeatures(brain2))
brain <- RunPCA(brain)
brain_fit_PCs <- fit_maple(brain,K = 6,emb = "PCs")
}


}
\keyword{Bayesian}
\keyword{spatial}
\keyword{transcriptomics}
