% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{register_resource}
\alias{register_resource}
\title{Register a new resource to the mapme.biodiversity}
\usage{
register_resource(
  name = NULL,
  type = NULL,
  source = NULL,
  fun = NULL,
  arguments = list()
)
}
\arguments{
\item{name}{A character vector indicating the name of the resource.}

\item{type}{A character vector indicating the type of the resource. Either
'vector' or 'raster'.}

\item{source}{Optional, preferably a URL where the data is found.}

\item{fun}{The function you wish to register.}

\item{arguments}{A list with named entries indicating the default values
for the arguments required by the function}
}
\value{
Nothing. Registers the function in the package environment.
}
\description{
Registers a custom resource function to access data or functionality
otherwise not native to \code{mapme.biodiversity} to be used with
\code{get_resources()}. Custom resources will also be registered in the list
generated by \code{available_resources()}.
}
\details{
Note that registering your own resource function will only have effect for
the current R session. If you return to your analysis in a new session, you
will have to re-register your custom resource.
}
\examples{
\dontrun{
register_resource(
  name = "gfw_treecover",
  type = "raster",
  source = "https://data.globalforestwatch.org/documents/tree-cover-2000/explore",
  fun = .get_gfw_treecover,
  arguments = list(vears_treecover = "GFC-2021-v1.9")
)
}
}
