% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_drought_indicator.R
\name{drought_indicator}
\alias{drought_indicator}
\alias{calc_drought_indicator}
\title{Calculate drought indicator statistics}
\usage{
calc_drought_indicator(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons
either one or multiple inputs as character "mean", "median" or "sd".}
}
\value{
A function that returns a tibble with a column for each specified
stats and a column with the respective date.
}
\description{
This function allows to efficiently calculate the relative wetness in the
shallow groundwater section with regard to the the 1948-2012 reference period.
The values represent the wetness percentile a given area achieves at a given
point in time in regard to the reference period.
For each polygon, the desired statistic/s (mean, median or sd) is/are
returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{nasa_grace}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_nasa_grace(years = 2022)) \%>\%
  calc_indicators(
    calc_drought_indicator(
      engine = "extract",
      stats = c("mean", "median")
    )
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
