% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get_tiles}
\alias{get_tiles}
\title{Get basemap tiles from map servers}
\usage{
get_tiles(
  x,
  provider = "OpenStreetMap",
  zoom,
  crop = FALSE,
  project = TRUE,
  verbose = FALSE,
  apikey,
  cachedir,
  forceDownload = FALSE
)
}
\arguments{
\item{x}{sf, sfc, bbox, SpatRaster, SpatVector or SpatExtent object.
If \code{x} is a SpatExtent it
must express coordinates in lon/lat WGS84 (epsg:4326).}

\item{provider}{tile server to get the tiles from. It can be one of
the builtin providers (see Details for the list) or a named list produced
by \link{create_provider} (see Examples).}

\item{zoom}{zoom level (see Details).}

\item{crop}{TRUE if results should be cropped to the specified x extent,
FALSE otherwise. If x is an sf object with one POINT, crop is set to FALSE.}

\item{project}{if TRUE, the output is projected to the crs of x.
If FALSE the output uses "EPSG:3857" (Web Mercator).}

\item{verbose}{if TRUE, tiles filepaths, zoom level and
attribution are displayed.}

\item{apikey}{API key. Not needed for Thunderforest or Stadia servers if
environment variables named "THUNDERFOREST_MAPS" or "STADIA_MAPS" are set.}

\item{cachedir}{name of a folder used to cache tiles. If not set, tiles
are cached in a \link[base:tempfile]{tempdir} folder.}

\item{forceDownload}{if TRUE, existing cached tiles may be overwritten.}
}
\value{
A SpatRaster is returned.
}
\description{
Get map tiles based on a spatial object extent. Maps can be
fetched from various map servers.
}
\details{
Zoom levels are described in the OpenStreetMap wiki:
\url{https://wiki.openstreetmap.org/wiki/Zoom_levels}. \cr\cr
Providers: \cr
"OpenStreetMap", "OpenStreetMap.DE", "OpenStreetMap.France",
"OpenStreetMap.HOT", "OpenTopoMap", \cr
"Stadia.Stamen.Toner", "Stadia.Stamen.TonerBackground",
"Stadia.Stamen.TonerLines", "Stadia.Stamen.TonerLabels",
"Stadia.Stamen.TonerLite",
"Stadia.Stamen.Watercolor", "Stadia.Stamen.Terrain",
"Stadia.Stamen.TerrainBackground",
"Stadia.Stamen.TerrainLabels", \cr
"Esri.WorldStreetMap",
"Esri.WorldTopoMap", "Esri.WorldImagery", "Esri.WorldTerrain",
"Esri.WorldShadedRelief", "Esri.OceanBasemap", "Esri.NatGeoWorldMap",
"Esri.WorldGrayCanvas", \cr
"CartoDB.Positron", "CartoDB.PositronNoLabels",
"CartoDB.PositronOnlyLabels", "CartoDB.DarkMatter",
"CartoDB.DarkMatterNoLabels",
"CartoDB.DarkMatterOnlyLabels", "CartoDB.Voyager", "CartoDB.VoyagerNoLabels",
"CartoDB.VoyagerOnlyLabels", \cr
"Thunderforest.OpenCycleMap", "Thunderforest.Transport",
"Thunderforest.TransportDark", "Thunderforest.SpinalMap",
"Thunderforest.Landscape",
"Thunderforest.Outdoors", "Thunderforest.Pioneer",
"Thunderforest.MobileAtlas",
"Thunderforest.Neighbourhood"
}
\examples{
\dontrun{
library(sf)
library(maptiles)
nc <- st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
nc_osm <- get_tiles(nc, crop = TRUE, zoom = 6)
plot_tiles(nc_osm)

# Create a provider from a custom url
osm_tiles <- create_provider(
  name = "osm_tiles",
  url = "https://tile.openstreetmap.org/{z}/{x}/{y}.png",
  citation = "© OpenStreetMap contributors."
)
# Download tiles and compose raster (SpatRaster)
nc_osm2 <- get_tiles(
  x = nc, provider = osm_tiles, crop = FALSE,
  zoom = 6, project = FALSE, verbose = TRUE
)
# Plot the tiles
plot_tiles(nc_osm2)
# Add attribution
mtext(get_credit(osm_tiles), side = 1, line = -1)
}
}
