% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garnishMap.R
\name{garnishMap}
\alias{garnishMap}
\title{Garnish/decorate leaflet or mapview maps.}
\usage{
garnishMap(map, ...)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{...}{functions and their arguments to add things to a map.}
}
\description{
This function provides a versatile interface to add components to a
leaflet or mapview map. It takes functions such as "addMouseCoordinates"
or \code{\link{addLayersControl}} and their respective arguments and adds
them to the map. Arguments must be named. Functions can be plain or
character strings.
}
\examples{
\dontrun{
m <- leaflet() \%>\% addTiles()
garnishMap(m, addMouseCoordinates)

## add more than one with named argument
library(raster)
m1 <- garnishMap(m, addMouseCoordinates, addHomeButton,
                 ext = extent(breweries91))
m1

## even more flexible
m2 <- garnishMap(m1, addPolygons, data = franconia, popup = popupTable(franconia),
                 fillOpacity = 0.8, color = "black", fillColor = "#BEBEBE")
garnishMap(m2, addCircleMarkers, data = breweries)

}

}
