% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ipw_scores.R
\name{get_ipw_scores}
\alias{get_ipw_scores}
\title{Construct evaluation scores via inverse-propensity weighting.}
\usage{
get_ipw_scores(Y, W, W.hat = NULL)
}
\arguments{
\item{Y}{The observed outcome.}

\item{W}{The observed treatment assignment (must be a factor vector,
where the first factor level is the control arm).}

\item{W.hat}{Optional treatment propensities. If these vary by unit and arm, then
this should be a matrix with the treatment assignment
probability of units to arms, with columns corresponding to the levels of \code{W}.
If these only vary by arm, a vector can also be supplied.
If W.hat is NULL (Default), then the assignment probabilities are assumed to be uniform
and the same for each arm.}
}
\value{
An \eqn{n \cdot K} matrix of evaluation scores.
}
\description{
A simple convenience function to
construct an evaluation score matrix via IPW, where entry (i, k) equals
\deqn{\frac{\mathbf{1}(W_i=k)Y_i}{P[W_i=k | X_i]} - \frac{\mathbf{1}(W_i=0)Y_i}{P[W_i=0 | X_i]},}
where \eqn{W_i} is the treatment assignment of unit i and \eqn{Y_i} the observed outcome.
\eqn{k = 1 \ldots K} are one of K treatment arms and k = 0 is the control arm.
}
\examples{
\donttest{
# Draw some equally likely samples from control arm A and treatment arms B and C.
n <- 5000
W <- as.factor(sample(c("A", "B", "C"), n, replace = TRUE))
Y <- 42 * (W == "B") - 42 * (W == "C") + rnorm(n)
IPW.scores <- get_ipw_scores(Y, W)
# An IPW-based estimate of E[Y(B) - Y(A)] and E[Y(C) - Y(A)]. Should be approx 42 and -42.
colMeans(IPW.scores)

# Draw non-uniformly from the different arms.
W.hat <- c(0.2, 0.2, 0.6)
W <- as.factor(sample(c("A", "B", "C"), n, replace = TRUE, prob = W.hat))
Y <- 42 * (W == "B") - 42 * (W == "C") + rnorm(n)
IPW.scores <- get_ipw_scores(Y, W, W.hat = W.hat)
# Should still be approx 42 and -42.
colMeans(IPW.scores)
}

}
