% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dydx_continuous.R
\name{get_dydx_continuous}
\alias{get_dydx_continuous}
\alias{get_dydx_continuous.default}
\title{Compute marginal effects (internal function)}
\usage{
get_dydx_continuous(model, ...)

\method{get_dydx_continuous}{default}(
  model,
  variable,
  fitfram = insight::get_data(model),
  group_name = NULL,
  type = "response",
  numDeriv_method = "simple",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}

\item{variable}{A string to identify the variable whose marginal effect to compute.}

\item{fitfram}{A data.frame over which to compute marginal effects.}

\item{group_name}{String to identify the "group" or "level" of the terms to
estimate. Groups are often used in models like multinomial logit where each
level of the response variable is associated to its own set of coefficients.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}
}
\value{
Numeric vector of marginal effects associated to a continuous regressor
}
\description{
Compute marginal effects (internal function)
}
\keyword{internal}
