% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_matrix.R
\name{get_model_matrix}
\alias{get_model_matrix}
\alias{get_model_matrix.default}
\title{Get a named model matrix}
\usage{
get_model_matrix(model, newdata)

\method{get_model_matrix}{default}(model, newdata)
}
\arguments{
\item{model}{Model object}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item Warning: Please avoid modifying your dataset between fitting the model and calling a \code{marginaleffects} function. This can sometimes lead to unexpected results.
\item \code{NULL} (default): Unit-level slopes for each observed value in the dataset (empirical distribution). The dataset is retrieved using \code{\link[insight:get_data]{insight::get_data()}}, which tries to extract data from the environment. This may produce unexpected results if the original data frame has been altered since fitting the model.
\item \code{\link[=datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[=datagrid]{datagrid()}} documentation.
}
\item \code{\link[=subset]{subset()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = subset(treatment == 1)}
\item \code{\link[dplyr:filter]{dplyr::filter()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = filter(treatment == 1)}
\item string:
\itemize{
\item "mean": Slopes evaluated when each predictor is held at its mean or mode.
\item "median": Slopes evaluated when each predictor is held at its median or mode.
\item "balanced": Slopes evaluated on a balanced grid with every combination of categories and numeric variables held at their means.
\item "tukey": Slopes evaluated at Tukey's 5 numbers.
\item "grid": Slopes evaluated on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}
}
\description{
Get a named model matrix
}
\keyword{internal}
