% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{marquee_glue}
\alias{marquee_glue}
\alias{marquee_glue_data}
\title{Marquee-aware string interpolation}
\usage{
marquee_glue(
  ...,
  .sep = "",
  .envir = parent.frame(),
  .open = "{",
  .close = "}",
  .na = "NA",
  .null = character(),
  .comment = character(),
  .literal = FALSE,
  .transformer = NULL,
  .trim = TRUE
)

marquee_glue_data(
  .x,
  ...,
  .sep = "",
  .envir = parent.frame(),
  .open = "{",
  .close = "}",
  .na = "NA",
  .null = character(),
  .comment = character(),
  .literal = FALSE,
  .transformer = NULL,
  .trim = TRUE
)
}
\arguments{
\item{...}{[\code{expressions}]\cr Unnamed arguments are taken to be expression
string(s) to format. Multiple inputs are concatenated together before formatting.
Named arguments are taken to be temporary variables available for substitution.

For \code{glue_data()}, elements in \code{...} override the values in \code{.x}.}

\item{.sep}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed, it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}

\item{.open}{[\code{character(1)}: \sQuote{\\\{}]\cr The opening delimiter. Doubling the
full delimiter escapes it.}

\item{.close}{[\code{character(1)}: \sQuote{\\\}}]\cr The closing delimiter. Doubling the
full delimiter escapes it.}

\item{.na}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace \code{NA} values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}

\item{.null}{[\code{character(1)}: \sQuote{character()}]\cr Value to replace
NULL values with. If \code{character()} whole output is \code{character()}. If
\code{NULL} all NULL values are dropped (as in \code{paste0()}). Otherwise the
value is replaced by the value of \code{.null}.}

\item{.comment}{[\code{character(1)}: \sQuote{#}]\cr Value to use as the comment
character.}

\item{.literal}{[\code{boolean(1)}: \sQuote{FALSE}]\cr Whether to treat single or
double quotes, backticks, and comments as regular characters (vs. as
syntactic elements), when parsing the expression string. Setting \code{.literal = TRUE} probably only makes sense in combination with a custom
\code{.transformer}, as is the case with \code{glue_col()}. Regard this argument
(especially, its name) as experimental.}

\item{.transformer}{[\code{function}]\cr A function taking two arguments, \code{text}
and \code{envir}, where \code{text} is the unparsed string inside the glue block and
\code{envir} is the execution environment. A \code{.transformer} lets you modify a
glue block before, during, or after evaluation, allowing you to create your
own custom \code{glue()}-like functions. See \code{vignette("transformers")} for
examples.}

\item{.trim}{[\code{logical(1)}: \sQuote{TRUE}]\cr Whether to trim the input
template with \code{\link[glue:trim]{trim()}} or not.}

\item{.x}{[\code{listish}]\cr An environment, list, or data frame used to lookup values.}
}
\value{
A character vector
}
\description{
If you want to create your markdown programmatically you'd probably want to
use some sort of string interpolation such as \code{glue()}. However, the custom
span syntax of marquee interferes with the standard interpolation syntax of
glue. This function let's you use both together.
}
\details{
If you choose a different set of delimiters than \code{"{"} and \code{"}"} for the
interpolation the functions will call the equivalent glue functions directly.
However, if you keep the defaults, the functions will use a custom
transformer that will make sure to keep the marquee custom span notation. You
can both interpolate the content of the span, as well as the span class (see
examples)
}
\examples{
# standard use
red_text <- "this text will be red"
marquee_glue("This will be black and {.red {red_text}}!")

# if the span is not valid it will be treated as standard glue interpolation
try(
  marquee_glue("This will be black and {.red}!")
)

# You can interpolate the tag name as well
col <- "green"
marquee_glue("This will be black and {.{col} this text will be {col}}!")

# Tag name interpolation must follow a `.` or a `#` as these identify the
# bracket pair as a custom span class
col <- ".yellow"
# This is not what you want probably
marquee_glue("This will be black and {{col} this text will be {col}}!")

# Tag interpolation should also interpolate the full tag and be followed by
# a space in order to be valid
part <- "l"
marquee_glue("This will be black and {.ye{part}low this text will be {col}}!")
try(
  marquee_glue("This will be black and {.{part}avender this text will be {col}}!")
)

}
