% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{get_significant_results}
\alias{get_significant_results}
\title{Find effects that are significant in at least one condition}
\usage{
get_significant_results(m, thresh = 0.05, conditions = NULL, sig_fn = get_lfsr)
}
\arguments{
\item{m}{the mash result (from joint or 1by1 analysis)}

\item{thresh}{indicates the threshold below which to call signals
significant}

\item{conditions}{which conditions to include in check (default to all)}

\item{sig_fn}{the significance function used to extract
significance from mash object; eg could be ashr::get_lfsr or
ashr::get_lfdr. (Small values must indicate significant.)}
}
\value{
a vector containing the indices of the significant effects,
by order of most significant to least
}
\description{
Find effects that are significant in at least one condition
}
\examples{
simdata = simple_sims(50,5,1)
data = mash_set_data(simdata$Bhat, simdata$Shat)
m = mash(data, cov_canonical(data))
get_significant_results(m)
}
