% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_get_bets.R
\name{mb_get_bets}
\alias{mb_get_bets}
\title{Get List of Current Bets on Matchbook}
\usage{
mb_get_bets(session_data, event_ids = NULL, market_ids = NULL,
  runner_ids = NULL, sides = NULL, status = NULL, interval = 0)
}
\arguments{
\item{session_data}{A session object returned from a successful mb_login attempt. It contains details about your user preferences and security details.}

\item{event_ids}{A vector of event_ids for which a list of current bets is required. This is an optional parameter and the default is to return bets from all events unless market_ids or runner_ids are specified.}

\item{market_ids}{A vector of market_ids for which a list of current bets is required. This is an optional parameter and the default is to return bets from all markets unless event_ids or runner_ids are specified.}

\item{runner_ids}{A vector of runner_ids for which a list of current bets is required. This is an optional parameter and the default is to return bets from all runners unless event_ids or market_ids are specified.}

\item{sides}{A filter to allow selection of either 'back' or 'lay' bets. The default is to return both types.}

\item{status}{The bet status from one of the possible options ('matched','unmatched','cancelled','expired','open','paused'). By default matched and unmatched bets are returned. Bets with status 'expired' can no longer be matched.}

\item{interval}{Time filter (in seconds) to allow selection of bets that were created or updated in the period between the currnet time and the current time minus the specified number of seconds.}
}
\value{
If successful, a dataframe with first 500 bets and associated information. Only 500 bets are permitted at one time. Pagination is possible but not implemented in this version.
The data frame has the following fields:
 \describe{
  \item{id}{the bet id}
  \item{event-id}{the event id on which the bet was placed}
  \item{event-name}{the name of the event on which the bet was placed}
  \item{event-id}{the event id on which the bet was placed}
  \item{market-id}{the market id on which the bet was placed}
  \item{market-name}{the name of the market on which the bet was placed}
  \item{runner-id}{the runner id on which the bet was placed}
  \item{runner-name}{the name of the runner on which the bet was placed}
  \item{exchange-type}{the exchange type. This should always be 'back-lay'}
  \item{side}{the side the bet was placed on}
  \item{odds}{the odds the bet was placed on}
  \item{odds-type}{the odds-type of the odds field }
  \item{decimal-odds}{the decimal version of the odds}
  \item{stake}{the stake placed}
  \item{remaining}{this field indicates how much of the original stake placed remains un-matched. If this value is equal to the original stake, the the bet is fully un-matched. If this value is zero, then the bet has been fully matched. Any value in-between indicates a partial match}   
  \item{potential-profit}{the potential profit if the matched component of this wager is successful}   
  \item{remaining-potential-profit}{the potential profit if the un-matched component of this wager is first matched and then has a successful outcome}   
  \item{currency}{The currency the bet stake was placed with}   
  \item{created-at}{The date the bet was placed}   
  \item{status}{The bet status. Status 'open' indicates an unmatched bet, 'matched' indicates a fully matched bet, 'cancelled' indicates a cancelled bet. For bets with status='open', the 'stake' and 'remaining' fields are key to determining the exact status. If the 'remaining' value is less than 'stake' but greater than zero, then the bet has been partially matched for a 'stake'-'remaining' amount. If the bet is fully un-matched, then the 'stake' and 'remaining' values will be equal.}   
  \item{temp-id}{the temporary id of the bet}
}
}
\description{
List the first 500 bets that have been made on Matchbook events that have not yet settled.
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","my_password"); 
mb_get_bets(session_data=my_session)}

}
\seealso{
\code{\link{mb_get_sports},\link{mb_get_events},\link{mb_get_markets}}
}

