/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistGeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLinear;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.layers.continuousSolver.Quimper;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class GeostNumeric {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private Setup stp = null;
    private Quimper engine = null;
    private int paramid = 0;
    private int varid = 0;
    private int ctrid = 0;
    private String listVars = "";
    private String listParams = "";
    private String listCstrs = "";
    private String listContractors = "";
    private Map<Obj, String> contractorName = new HashMap<Obj, String>();
    private Map<IntDomainVar, List<Integer>> VarVarId = new HashMap<IntDomainVar, List<Integer>>();
    private Map<IntDomainVar, List<Integer>> varParamId = new HashMap<IntDomainVar, List<Integer>>();
    private Map<IntDomainVar, Boolean> listOfVars = new HashMap<IntDomainVar, Boolean>();
    private Map<IntDomainVar, HashMap<ExternalConstraint, Integer>> VarParamId = new HashMap<IntDomainVar, HashMap<ExternalConstraint, Integer>>();
    private Map<Obj, HashMap<ExternalConstraint, String>> ObjParamIdText = new HashMap<Obj, HashMap<ExternalConstraint, String>>();
    private Map<Obj, HashMap<ExternalConstraint, String>> ObjCstrName = new HashMap<Obj, HashMap<ExternalConstraint, String>>();
    private long cr = -1L;
    private double isThick = 0.0;

    public GeostNumeric(Setup stp_, int maxNbrOfBoxes) {
        Obj o;
        int oid;
        this.stp = stp_;
        this.cr = this.computeConversionRate();
        this.isThick = this.computeIsThick(maxNbrOfBoxes);
        for (oid = 0; oid < this.stp.getObjectKeySet().size(); ++oid) {
            o = this.stp.getObject(oid);
            this.addObj(o);
        }
        for (oid = 0; oid < this.stp.getObjectKeySet().size(); ++oid) {
            o = this.stp.getObject(oid);
            for (ExternalConstraint ectr : o.getRelatedExternalConstraints()) {
                this.addCstr(o, ectr);
            }
            this.writeContractor(o);
        }
        this.writeFile("/tmp/quimper.qpr");
        this.engine = new Quimper("/tmp/quimper.qpr");
    }

    private void addObj(Obj o) {
        this.listVars = this.listVars + this.strObj(o);
        int k = o.getCoordinates().length;
        for (int d = 0; d < k; ++d) {
            IntDomainVar v = o.getCoord(d);
            this.addVar(v);
        }
    }

    private void addVar(IntDomainVar v) {
        if (!this.VarVarId.containsKey(v)) {
            this.VarVarId.put(v, new ArrayList());
        }
        this.VarVarId.get(v).add(this.varid++);
        this.listOfVars.put(v, true);
    }

    private String strObj(Obj o) {
        StringBuilder r = new StringBuilder();
        int k = o.getCoordinates().length;
        r.append("o").append(o.getObjectId()).append("[").append(k).append("] in [");
        for (int d = 0; d < k; ++d) {
            r.append("[");
            r.append(this.coordToExtEngine(o.getCoord(d).getInf())).append("/*").append(o.getCoord(d).getInf()).append("*/,");
            r.append(this.coordToExtEngine(o.getCoord(d).getSup())).append("/*").append(o.getCoord(d).getSup()).append("*/");
            if (d == k - 1) {
                r.append("]");
                continue;
            }
            r.append("];");
        }
        r.append("];\n");
        return r.toString();
    }

    private String strParam(Obj o, ExternalConstraint ectr) {
        StringBuilder r = new StringBuilder();
        int k = o.getCoordinates().length;
        r.append(this.ObjParamIdText.get(o).get(ectr)).append("[").append(k).append("] in [");
        for (int d = 0; d < k; ++d) {
            r.append("[");
            r.append(this.coordToExtEngine(o.getCoord(d).getInf())).append("/*").append(o.getCoord(d).getInf()).append("*/,");
            r.append(this.coordToExtEngine(o.getCoord(d).getSup())).append("/*").append(o.getCoord(d).getSup()).append("*/");
            if (d == k - 1) {
                r.append("]");
                continue;
            }
            r.append("];");
        }
        r.append("];\n");
        return r.toString();
    }

    private void addParam(Obj o, ExternalConstraint ectr) {
        if (ectr instanceof DistLeq) {
            int oid;
            DistLeq dl = (DistLeq)ectr;
            int toAdd = oid = o.getObjectId();
            toAdd = dl.o1 == oid ? dl.o2 : dl.o1;
            this.addObjParamText(this.stp.getObject(toAdd), ectr);
            this.listParams = this.listParams + this.strParam(this.stp.getObject(toAdd), ectr);
            if (dl.hasDistanceVar()) {
                this.addVarParam(dl.getDistanceVar(), ectr);
                this.listParams = this.listParams + this.strParam(dl.getDistanceVar(), ectr);
            }
        } else if (ectr instanceof DistGeq) {
            int oid;
            DistGeq dl = (DistGeq)ectr;
            int toAdd = oid = o.getObjectId();
            toAdd = dl.o1 == oid ? dl.o2 : dl.o1;
            this.addObjParamText(this.stp.getObject(toAdd), ectr);
            this.listParams = this.listParams + this.strParam(this.stp.getObject(toAdd), ectr);
            if (dl.hasDistanceVar()) {
                this.addVarParam(dl.getDistanceVar(), ectr);
                this.listParams = this.listParams + this.strParam(dl.getDistanceVar(), ectr);
            }
        } else if (!(ectr instanceof DistLinear)) {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:addParam():External Constraint " + ectr + " not supported yet.");
        }
        ++this.ctrid;
    }

    private String strParam(IntDomainVar v, ExternalConstraint ectr) {
        String name = MessageFormat.format("p{0}", this.VarParamId.get(v).get(ectr));
        StringBuilder r = new StringBuilder(MessageFormat.format("{0} in ", name));
        r.append("[");
        r.append(this.coordToExtEngine(v.getInf())).append(",");
        r.append(this.coordToExtEngine(v.getSup()));
        r.append("];\n");
        return r.toString();
    }

    private void addObjParamText(Obj o, ExternalConstraint ectr) {
        if (this.ObjParamIdText.get(o) == null) {
            this.ObjParamIdText.put(o, new HashMap());
        }
        this.ObjParamIdText.get(o).put(ectr, this.strObjName(o));
        for (IntDomainVar v : o.getCoordinates()) {
            this.addVarParam(v, ectr);
            ++this.paramid;
        }
    }

    private String strObjName(Obj o) {
        return "o" + o.getObjectId() + "_ctr" + this.ctrid;
    }

    private void addVarParam(IntDomainVar v, ExternalConstraint ectr) {
        if (this.VarParamId.get(v) == null) {
            this.VarParamId.put(v, new HashMap());
        }
        this.VarParamId.get(v).put(ectr, this.paramid);
        if (this.varParamId.get(v) == null) {
            this.varParamId.put(v, new ArrayList());
        }
        this.varParamId.get(v).add(this.paramid);
        this.listOfVars.put(v, true);
        ++this.paramid;
    }

    private void addCstr(Obj o, ExternalConstraint ectr) {
        this.addParam(o, ectr);
        this.listCstrs = this.listCstrs + this.strCstr(o, ectr);
        this.addCstrName(o, ectr);
        ++this.ctrid;
    }

    private void addCstrName(Obj o, ExternalConstraint ectr) {
        String name = this.strCstrName(o);
        if (this.ObjCstrName.get(o) == null) {
            this.ObjCstrName.put(o, new HashMap());
        }
        this.ObjCstrName.get(o).put(ectr, name);
    }

    private String strCstr(Obj o, ExternalConstraint ectr) {
        StringBuilder r = new StringBuilder();
        if (ectr instanceof DistLeq) {
            DistLeq dl = (DistLeq)ectr;
            int oid = o.getObjectId();
            r.append(MessageFormat.format("constraint {0}\n", this.strCstrName(o)));
            if (dl.hasDistanceVar()) {
                r.append(" distance(o").append(oid).append(",").append(this.getObjectParamIdText(this.stp.getObject(dl.o2), ectr)).append(")<=").append(this.getVarParamIdText(dl.getDistanceVar(), ectr)).append(";\n");
            } else {
                r.append(" distance(o").append(oid).append(",").append(this.getObjectParamIdText(this.stp.getObject(dl.o2), ectr)).append(")<=").append(this.coordToExtEngine(dl.D / 2)).append("/*").append(dl.D).append("*/;\n");
            }
            r.append("end\n");
        } else if (ectr instanceof DistGeq) {
            DistGeq dl = (DistGeq)ectr;
            int oid = o.getObjectId();
            r.append("constraint ").append(this.strCstrName(o)).append("\n");
            if (dl.hasDistanceVar()) {
                r.append(" distance(o").append(oid).append(",").append(this.getObjectParamIdText(this.stp.getObject(dl.o2), ectr)).append(")>=").append(this.getVarParamIdText(dl.getDistanceVar(), ectr)).append(";\n");
            } else {
                r.append(" distance(o").append(oid).append(",").append(this.getObjectParamIdText(this.stp.getObject(dl.o2), ectr)).append(")>=").append(this.coordToExtEngine(dl.D)).append("/*").append(dl.D).append("*/;\n");
            }
            r.append("end\n");
        } else if (ectr instanceof DistLinear) {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:strCstr():External Constraint " + ectr + " not supported yet.");
        }
        return r.toString();
    }

    private String getObjectParamIdText(Obj o, ExternalConstraint ectr) {
        return this.ObjParamIdText.get(o).get(ectr);
    }

    private String strCstrName(Obj o) {
        return "obj" + o.getObjectId() + "_c" + this.ctrid;
    }

    private String getVarParamIdText(IntDomainVar v, ExternalConstraint ectr) {
        return "p" + this.VarParamId.get(v).get(ectr);
    }

    private double computeIsThick(int maxNbrOfBoxes) {
        if (this.cr == -1L) {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:computeIsThick:conversion ratio cr must be computed before isThick can be compured");
        }
        double maxNbrOfBoxesDouble = maxNbrOfBoxes;
        int k = this.stp.getObject(0).getCoordinates().length;
        double volume = this.volume();
        LOGGER.info("volume:" + String.format("%f", volume));
        this.isThick = 1.0;
        double inverse_k = 1.0 / (double)k;
        if (inverse_k <= 0.0) {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:computeIsThick:unable to compute isThick because of 1/k:" + inverse_k);
        }
        return Math.pow(volume / maxNbrOfBoxesDouble, inverse_k) / (double)this.cr;
    }

    private long volume() {
        int k = this.stp.getObject(0).getCoordinates().length;
        long volume = 1L;
        for (int dim = 0; dim < k; ++dim) {
            int min = this.stp.getObject(0).getCoord(dim).getInf();
            int max = this.stp.getObject(0).getCoord(dim).getSup();
            for (int i : this.stp.getObjectKeySet()) {
                Obj o = this.stp.getObject(i);
                min = Math.min(min, o.getCoord(dim).getInf());
                max = Math.max(max, o.getCoord(dim).getSup());
            }
            volume *= (long)Math.abs(max - min);
        }
        return volume;
    }

    private long computeConversionRate() {
        int min = this.stp.getObject(0).getCoord(0).getInf();
        int max = this.stp.getObject(0).getCoord(0).getSup();
        for (int i : this.stp.getObjectKeySet()) {
            Obj o = this.stp.getObject(i);
            for (int j = 0; j < o.getCoordinates().length; ++j) {
                min = Math.min(min, o.getCoord(j).getInf());
                max = Math.max(max, o.getCoord(j).getSup());
            }
        }
        long cr_min = 1L;
        while ((long)min / cr_min > 0L) {
            if ((cr_min *= 10L) >= 0L) continue;
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:computeConversionRate:long limit cr_min exceeded");
        }
        long cr_max = 1L;
        while ((long)max / cr_max > 0L) {
            if ((cr_max *= 10L) >= 0L) continue;
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:computeConversionRate:long limit cr_max exceeded");
        }
        return Math.max(cr_min, cr_max);
    }

    private double coordToExtEngine(int v) {
        double vd = v;
        return vd / (double)this.cr;
    }

    private void writeContractor(Obj o) {
        List<ExternalConstraint> vectr = o.getRelatedExternalConstraints();
        if (vectr.size() > 0) {
            this.listContractors = this.listContractors + "contractor object" + o.getObjectId() + "\npropag(";
            for (int i = 0; i < vectr.size(); ++i) {
                String ctrname = this.ObjCstrName.get(o).get(vectr.get(i));
                this.listContractors = i == vectr.size() - 1 ? this.listContractors + ctrname + ");" : this.listContractors + ctrname + ";";
            }
            this.listContractors = this.listContractors + "\nend/*listContractors*/\n";
            this.contractorName.put(o, "object" + o.getObjectId());
        }
    }

    private void writeFile(String filename) {
        try {
            File f = new File(filename);
            PrintWriter pw = new PrintWriter(new FileWriter(f));
            pw.println("Variables");
            pw.println(this.listVars);
            pw.println("Parameters");
            pw.println(this.listParams);
            pw.println("function d=distance(x[2],y[2])\n\td=sqrt((x[1]-y[1])^2+(x[2]-y[2])^2);\nend");
            pw.println(this.listCstrs);
            pw.println(this.listContractors);
            pw.println("contractor isthick\nmaxdiamGT(" + String.format("%f", this.isThick).replace(",", ".") + ");\nend\n");
            pw.close();
        }
        catch (Exception e) {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:writeFile():could not write file");
        }
    }

    public void synchronize() {
        for (IntDomainVar v : this.listOfVars.keySet()) {
            this.synchronize(v);
        }
    }

    public void synchronize(Obj o) {
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            IntDomainVar v = o.getCoord(i);
            for (int id : this.VarVarId.get(v)) {
                double inf = this.coordToExtEngine(v.getInf());
                double sup = this.coordToExtEngine(v.getSup());
                this.engine.set_var_domain(id, inf, sup);
            }
        }
    }

    public void synchronize(IntDomainVar v) {
        List<Integer> a = this.VarVarId.get(v);
        List<Integer> b = this.varParamId.get(v);
        if (a != null) {
            for (int id : this.VarVarId.get(v)) {
                double inf = this.coordToExtEngine(v.getInf());
                double sup = this.coordToExtEngine(v.getSup());
                this.engine.set_var_domain(id, inf, sup);
            }
        } else if (b != null) {
            List<Integer> vint = this.varParamId.get(v);
            for (int i = 0; i < vint.size(); ++i) {
                int id = vint.get(i);
                double inf = this.coordToExtEngine(v.getInf());
                double sup = this.coordToExtEngine(v.getSup());
                this.engine.set_var_domain(id, inf, sup);
            }
        } else {
            throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:synchronize:IntDomainVar not found");
        }
    }

    public void synchronize(ExternalConstraint ectr) {
        throw new SolverException("choco.cp.solver.constraints.global.geost.layers.GeostNumeric:synchronize:External Constraints are not supported yet.");
    }

    public Region propagate(Obj o) {
        LOGGER.info("--Entering GeostNumeric:propagate()");
        int k = o.getCoordinates().length;
        if (this.contractorName.get(o) == null) {
            return new Region(k, o);
        }
        LOGGER.info("calling contract(object" + o.getObjectId() + ") because of contractorName.get(" + o + ")=" + this.contractorName.get(o));
        this.engine.contract("object" + o.getObjectId());
        Region r = new Region(k, o.getObjectId());
        for (int i = 0; i < k; ++i) {
            String id = MessageFormat.format("o{0}[{1}]", o.getObjectId(), i);
            double lb = this.engine.get_lb(id);
            double ub = this.engine.get_ub(id);
            int lb_int = (int)Math.floor(lb * (double)this.cr);
            int ub_int = (int)Math.ceil(ub * (double)this.cr);
            r.setMinimumBoundary(i, lb_int);
            r.setMaximumBoundary(i, ub_int);
        }
        LOGGER.info("--Exiting GeostNumeric:propagate()");
        return r;
    }

    public void prune(Obj o, int k, List<InternalConstraint> ictrs) throws ContradictionException {
        LOGGER.info("Entering Prune:" + o + "," + k + "," + ictrs);
        this.synchronize();
        Region box = this.propagate(o);
        for (int i = 0; i < k; ++i) {
            int min = box.getMinimumBoundary(i);
            int max = box.getMaximumBoundary(i);
            int min_ori = o.getCoord(i).getInf();
            int max_ori = o.getCoord(i).getSup();
            LOGGER.info("Prune():" + o + "[" + i + "] updated to [" + min + "," + max + "]");
            boolean var_was_modified = false;
            if (min > min_ori) {
                var_was_modified = true;
                o.getCoord(i).setInf(min);
            }
            if (max < max_ori) {
                var_was_modified = true;
                o.getCoord(i).setSup(max);
            }
            if (var_was_modified) {
                this.synchronize(o.getCoord(i));
            }
            LOGGER.info("Prune():synchronize o[" + i + "]=[" + o.getCoord(i).getInf() + "," + o.getCoord(i).getSup() + "]");
        }
        LOGGER.info("Exiting Prune()");
    }
}

