/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.util.PrefetchIterator;
import org.jgrapht.util.TypeUtil;

class MaskVertexSet<V, E>
extends AbstractSet<V> {
    private MaskFunctor<V, E> mask;
    private int size;
    private Set<V> vertexSet;
    private transient TypeUtil<V> vertexTypeDecl = null;

    public MaskVertexSet(Set<V> set, MaskFunctor<V, E> maskFunctor) {
        this.vertexSet = set;
        this.mask = maskFunctor;
        this.size = -1;
    }

    @Override
    public boolean contains(Object object) {
        return !this.mask.isVertexMasked(TypeUtil.uncheckedCast(object, this.vertexTypeDecl)) && this.vertexSet.contains(object);
    }

    @Override
    public Iterator<V> iterator() {
        return new PrefetchIterator(new MaskVertexSetNextElementFunctor());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<V> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }
        return this.size;
    }

    private class MaskVertexSetNextElementFunctor
    implements PrefetchIterator.NextElementFunctor<V> {
        private Iterator<V> iter;

        public MaskVertexSetNextElementFunctor() {
            this.iter = MaskVertexSet.this.vertexSet.iterator();
        }

        @Override
        public V nextElement() throws NoSuchElementException {
            Object v = this.iter.next();
            while (MaskVertexSet.this.mask.isVertexMasked(v)) {
                v = this.iter.next();
            }
            return v;
        }
    }
}

