/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.Occurrence;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class OccurrenceManager
extends IntConstraintManager {
    private static final int NOR = 0;
    private static final int MIN = -1;
    private static final int MAX = 1;

    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Integer) {
            int type = (Integer)parameters;
            IntegerVariable[] vars = new IntegerVariable[variables.length - 1];
            vars[vars.length - 1] = variables[1];
            System.arraycopy(variables, 2, vars, 0, vars.length - 1);
            if (type == 0) {
                return new Occurrence(solver.getVar(vars), ((IntegerConstantVariable)variables[0]).getValue(), true, true, solver.getEnvironment());
            }
            if (type == -1) {
                return new Occurrence(solver.getVar(vars), ((IntegerConstantVariable)variables[0]).getValue(), true, false, solver.getEnvironment());
            }
            if (type == 1) {
                return new Occurrence(solver.getVar(vars), ((IntegerConstantVariable)variables[0]).getValue(), false, true, solver.getEnvironment());
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public SConstraint[] makeConstraintAndOpposite(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        SConstraint[] cs = new SConstraint[2];
        if (solver instanceof CPSolver && parameters instanceof Integer) {
            int type = (Integer)parameters;
            IntDomainVar X = solver.getVar(variables[1]);
            IntDomainVar Y = X.hasBooleanDomain() ? solver.createBooleanVar("Y_opp") : (X.hasEnumeratedDomain() ? solver.createEnumIntVar("Y_opp", X.getInf(), X.getSup()) : solver.createBoundIntVar("Y_opp", X.getInf(), X.getSup()));
            IntegerVariable[] tvars = new IntegerVariable[variables.length - 2];
            System.arraycopy(variables, 2, tvars, 0, tvars.length);
            IntDomainVar[] vars = ArrayUtils.append(solver.getVar(tvars), {Y});
            if (type == 0) {
                solver.post(new Occurrence(vars, ((IntegerConstantVariable)variables[0]).getValue(), true, true, solver.getEnvironment()));
            } else if (type == -1) {
                solver.post(new Occurrence(vars, ((IntegerConstantVariable)variables[0]).getValue(), true, false, solver.getEnvironment()));
            } else if (type == 1) {
                solver.post(new Occurrence(vars, ((IntegerConstantVariable)variables[0]).getValue(), false, true, solver.getEnvironment()));
            }
            cs[0] = solver.eq((IntExp)Y, (IntExp)X);
            cs[1] = solver.neq((IntExp)Y, (IntExp)X);
            return cs;
        }
        throw new ModelException("Could not found a constraint and opposite manager in " + this.getClass() + " !");
    }
}

