/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb;

import choco.cp.solver.constraints.integer.intlincomb.IntLinCombOp;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class IntLinCombNEQ
extends IntLinCombOp {
    public IntLinCombNEQ(int[] coeffs, int nbPosVars, int cste, IntDomainVar[] vars, AbstractSConstraint constraint) {
        super(coeffs, nbPosVars, cste, vars, constraint);
    }

    @Override
    public Boolean isEntailed() {
        int a = this.coeffPolicy.computeLowerBound();
        if (a > 0) {
            return Boolean.TRUE;
        }
        int b = this.coeffPolicy.computeUpperBound();
        if (b < 0) {
            return Boolean.TRUE;
        }
        if (b == 0 && a == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.compute(tuple) != 0;
    }

    @Override
    public boolean filterOnImprovedLowerBound() throws ContradictionException {
        return this.coeffPolicy.computeLowerBound() == 0 && this.propagateNewUpperBound(this.coeffPolicy.computeUpperBound() - 1);
    }

    @Override
    public boolean filterOnImprovedUpperBound() throws ContradictionException {
        return this.coeffPolicy.computeUpperBound() == 0 && this.propagateNewLowerBound(this.coeffPolicy.computeLowerBound() + 1);
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public AbstractSConstraint opposite(Solver solver) {
        IntExp term = solver.scalar(this.coeffs, this.vars);
        return (AbstractSConstraint)solver.eq(term, -this.cste);
    }

    @Override
    protected String getOperator() {
        return " =/= ";
    }
}

