% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{galeShapleyMatching}
\alias{galeShapleyMatching}
\title{Compute the Gale-Shapley Algorithm}
\usage{
galeShapleyMatching(proposerPref, reviewerUtils)
}
\arguments{
\item{proposerPref}{is a matrix with the preference order of the proposing side of
the market (using C++ indexing that starts at zero)}

\item{reviewerUtils}{is a matrix with cardinal utilities of the courted side of the
market}
}
\value{
A list with the successful proposals and engagements.
\code{proposals} is a vector whose nth element contains the id of the reviewer
that proposer n is matched to (using C++ indexing that starts at zero).
\code{engagements} is a vector whose nth element contains the id of the proposer
that reviewer n is matched to (using C++ indexing that starts at zero).
}
\description{
This function provides an R wrapper for the C++ backend. Users should not
call this function directly and instead use \code{one2one}, \code{many2one},
\code{one2many}.
}

