% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gg.R
\name{plot_gg}
\alias{plot_gg}
\title{Plot genealogical tree with \code{ggenealogy}}
\usage{
plot_gg(g, max_anc = 3L, max_des = 3L, id = NULL, col = "red", expand = 0.15)
}
\arguments{
\item{g}{an object of class \code{genealogy}, as returned by \code{\link[=get_genealogy]{get_genealogy()}}.}

\item{max_anc}{an \code{integer(1)} with the maximum number of generations of ancestors to be displayed.}

\item{max_des}{an \code{integer(1)} with the maximum number of generations of descendants to be displayed.}

\item{id}{an \code{integer(1)} or \code{character(1)} with the mathematician ID to highlight and centre the tree on.
By default this is \code{NULL} which will use the first ID that was supplied to \code{\link[=get_genealogy]{get_genealogy()}} when retrieving the genealogical tree.
Note that the ID must be one of the IDs searched when calling \code{\link[=get_genealogy]{get_genealogy()}} to construct \code{g}, since the search for ancestors/descendants only goes directly up/down branches reachable from the initial search ID.}

\item{col}{a \code{character(1)} specifying the colour to highlight the mathematician one whom the graph is centred.}

\item{expand}{a \code{numeric(1)} with the expansion factor for the graph.
This defaults to \code{0.15}, with larger values causing the \code{x} axis to expand, smaller values for it to shrink.
This is useful if the nearest common ancestor has a long name, which may cause it to be clipped when plotting: increase this expansion factor to rectify this.}
}
\value{
An object of class \verb{("gg", "ggplot")} which can be displayed, or further manipulated using additional layers or aesthetic modifications from the \code{\link[ggplot2:ggplot2-package]{ggplot2}} package.
}
\description{
Plots a genealogical tree using the \code{ggenealogy} layout engine.
}
\details{
This function requires the \code{ggenealogy} package to be installed.
It is only a "Suggests" dependency because this package supports multiple plotting approaches.
The presence of this package will be verified when the function is actually called, providing an opportunity to install automatically if needed.

This function is not suitable for plotting very large whole genealogical trees.
Consider using \code{\link[=plot_grviz]{plot_grviz()}} if you want to see an entire tree.
}
\examples{
# First, you need to use search_id() to find the mathematician ID for the
# individual(s) you wish to plot, or visit https://mathgenealogy.org/ to look
# up in the browser.

# Don't test these as rely on internet resources that can be temporarily
# unavailable.
\donttest{
# For example, the package author would get their own tree using
g <- get_genealogy(171971)

# Then use the plot_gg() function to use the underlying ggenealogy package
plot_gg(g)
}
}
\references{
Rutter, L., VanderPlas, S., Cook, D. and Graham, M.A. (2019). “ggenealogy: An R Package for Visualizing Genealogical Data”, \emph{Journal of Statistical Software}, \strong{89}(13), 1-31. \doi{10.18637/jss.v089.i13}.

Wickham, H. (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}. Springer-Verlag New York.
}
