% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questdlg.R
\name{questdlg}
\alias{questdlg}
\title{Prompt for multiple-choice}
\usage{
questdlg(
  quest,
  dlgtitle = "",
  btn = c("y", "n"),
  defbtn = "n",
  accepted_ans = c("y", "yes", "n", "no")
)
}
\arguments{
\item{quest}{Question}

\item{dlgtitle}{Title of question}

\item{btn}{Vector of alternatives}

\item{defbtn}{Scalar with the name of the default option}

\item{accepted_ans}{Vector containing accepted answers}
}
\value{
Whatever is entered by the user after the prompt created by the function.
}
\description{
This function aims to loosely mimic the behavior of the
questdlg function on Matlab
}
\examples{
\dontrun{
  ans <- questdlg("Do you want to continue?", "Continue?")
  if (tolower(substring(ans, 1, 1)) == "y") {
    message("You typed yes")
  } else {
    message("You didn't type yes")
  }
}
}
