% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{echelon}
\alias{echelon}
\title{Echelon Form of a Matrix}
\usage{
echelon(X, ...)
}
\arguments{
\item{X}{a matrix}

\item{...}{other arguments passed to \code{gaussianElimination}}
}
\value{
the reduced echelon form of \code{X}.
}
\description{
Returns the reduced row-echelon form of the matrix \code{X}, using \code{\link{gaussianElimination}}.
It is nothing more than a synonym for Gaussian elimination, but offers the possibility to show the
steps using \code{verbose=TRUE}.
}
\details{
When the matrix \code{x} is square and non-singular, the result will be the identity matrix. Otherwise,
the result will have some all-zero rows, and the rank of the matrix is the number of not all-zero rows.
}
\examples{
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
b <- c(8, -11, -3)
echelon(A, b, verbose=TRUE, fractions=TRUE)

A <- matrix(c(1,2,3,4,5,6,7,8,10), 3, 3) # a nonsingular matrix
A
echelon(A) # the reduced row-echelon form of A

b <- 1:3
echelon(A, b)  # solving the matrix equation Ax = b
echelon(A, diag(3)) # inverting A

B <- matrix(1:9, 3, 3) # a singular matrix
B
echelon(B)
echelon(B, b)
echelon(B, diag(3))

}

