#' matlib: Matrix Functions for Teaching and Learning Linear Algebra and Multivariate Statistics.
#'
#'
#' These functions are designed mainly for tutorial purposes in teaching & learning matrix algebra
#' ideas and applications to statistical methods using R.
#'
#' In some cases, functions are provided for concepts available
#' elsewhere in R, but where the function call or name is not obvious.  In other
#' cases, functions are provided to show or demonstrate an algorithm, sometimes
#' providing a \code{verbose} argument to print the details of computations.
#'
#' In addition,
#' a collection of functions are provided for drawing vector diagrams in 2D and 3D.
#'
#' These are not meant for production uses. Other methods are more efficient for larger problems.
#'
#' @section Topics:
#' The functions in this package are grouped under the following topics
#' \itemize{
#'   \item Convenience functions: \cr
#'         \code{\link{tr}}, \code{\link{R}}, \code{\link{J}}, \code{\link{len}},
#'         \code{\link{vec}}, \code{\link{Proj}}, \code{\link{mpower}}, \code{\link{vandermode}}
#'   \item Determinants: functions for calculating determinants by cofactor expansion \cr
#'         \code{\link{minor}}, \code{\link{cofactor}}, \code{\link{rowMinors}}, \code{\link{rowCofactors}}
#'   \item Elementary row operations: functions for solving linear equations "manually" by the steps used in
#'         row echelon form and Gaussian elimination \cr
#'         \code{\link{rowadd}}, \code{\link{rowmult}}, \code{\link{rowswap}}
#'   \item Linear equations: functions to illustrate linear equations of the form $A x = b$ \cr
#'         \code{\link{showEqn}}, \code{\link{plotEqn}}
#'   \item Gaussian elimination: functions for illustrating Gaussian elimination for solving
#'         systems of linear equations of the form $A x = b$. \cr
#'         \code{\link{gaussianElimination}}, \code{\link{Inverse}}, \code{\link{inv}}, \code{\link{echelon}},
#'         \code{\link{Ginv}}, \code{\link{LU}}, \code{\link{cholesky}}, \code{\link{swp}}
#'   \item Eigenvalues: functions to illustrate the algorithms for calculating eigenvalues
#'         and eigenvectors \cr
#'         \code{\link{eigen}}, \code{\link{SVD}}, \code{\link{powerMethod}}, \code{\link{showEig}}
#'   \item Vector diagrams: functions for drawing vector diagrams in 2D and 3D \cr
#'         \code{\link{arrows3d}}, \code{\link{corner}}, \code{\link{arc}}, \code{\link{pointOnLine}},
#'         \code{\link{vectors}}, \code{\link{vectors3d}}, \code{\link{regvec3d}}
#' }
#'
#' Most of these ideas and implementations arose in courses and books by the authors.
#' [Psychology 6140](http://friendly.apps01.yorku.ca/psy6140/) was a starting point.
#' Fox (1984) introduced illustrations of vector geometry.
#'
#' @section macOS Installation Note:
#' The functions that draw 3D graphs use the \pkg{rgl} package.
#' On macOS, the \pkg{rgl} package requires that \href{https://www.xquartz.org/}{XQuartz}
#' be installed. After installing XQuartz, it's necessary either to log out of and back
#' into your macOS account or to reboot your Mac.
#'
#' @name matlib-package
#' @aliases matlib-package
#' @importFrom MASS fractions
#' @aliases matlib
#' @references
#' Fox, J. Linear Statistical Models and Related Methods. John Wiley and Sons, 1984
#'
#' Fox, J. and Friendly, M. (2016). "Visualizing Simultaneous Linear Equations, Geometric Vectors, and
#' Least-Squares Regression with the matlib Package for R". \emph{useR Conference}, Stanford, CA, June 27 - June 30, 2016.

NULL











