% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{predictValue}
\alias{predictValue}
\title{Predicts the value for items}
\usage{
predictValue(
  data,
  value,
  item,
  timestamp,
  temporalAggregation = c("day", "week", "month", "quarter", "year"),
  aggregationFun = sum,
  timeUnitsAhead = 1,
  digits = 3,
  expand = F,
  keepPreviousData = F,
  level = 0.95,
  ...
)
}
\arguments{
\item{data}{Data frame including previous values.}

\item{value}{Name of the column representing the item value.}

\item{item}{Name of the column representing the item ID or the item name.}

\item{timestamp}{Name of the column including the timestamp. This column should be in POSIX or date-format.}

\item{temporalAggregation}{Temporal aggregation mode (i.e., "day", "week", "month", "quarter", "year").}

\item{aggregationFun}{Function for aggregating the value column. Default is sum.}

\item{timeUnitsAhead}{Integer indicating the number of time units (i.e., days, weeks, months, quarters or years) the should be predicted.}

\item{digits}{Integer indicating the number of significant digits used for the predicted values.}

\item{expand}{Logical indicating whether the data will be expanded after they are aggregated. Default is not (FALSE).}

\item{keepPreviousData}{Logical indicating whether the data from the given data frame will be added to the result or not. Default is not (FALSE).}

\item{level}{Numeric value representing the confidence level for the predictions. The default is 0.95 (i.e. lower level = 0.025 and upper level
= 0.975).}

\item{...}{Further arguments for function forecast::auto.arima.}
}
\value{
Returns a \code{Forecast} object.
}
\description{
Predicts the value for items based on previous values. Previous values can be aggregated to value
per day, week, month, quarter or year. An ARIMA model is estimated for each item based on the function
forecast:auto.arima. The best model is selected and used for prediction. Note that only models without
drift term will be considered in order to ensure consistent predictions.
}
\examples{
# Simple Example
data("Amount")
prediction = predictValue(data = Amount,
    value = "amount",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    timeUnitsAhead = 3)
prediction

# More Sophisticated Example
data("Amount")
prediction = predictValue(data = Amount,
    value = "amount",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    aggregationFun = mean,
    timeUnitsAhead = 5,
    digits = 4,
    keepPreviousData = TRUE,
    level = 0.9,
    trace = TRUE)
prediction
}
\seealso{
\code{\link[forecast]{auto.arima}} \code{\link[=Forecast-class]{Forecast}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
