% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_filter.R
\name{sim_filter_keep_or_drop_some}
\alias{sim_filter_keep_or_drop_some}
\title{Filter a melted similarity matrix to remove or keep specified rows.}
\usage{
sim_filter_keep_or_drop_some(
  sim_df,
  row_metadata,
  filter_keep = NULL,
  filter_drop = NULL,
  filter_side = NULL
)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{row_metadata}{data.frame with row metadata.}

\item{filter_keep}{optional data.frame of metadata specifying which
rows to keep.}

\item{filter_drop}{optional data.frame of metadata specifying which
rows to drop.}

\item{filter_side}{character string specifying which index to filter on.
This must be one of the strings \code{"left"} or \code{"right"}.}
}
\value{
Filtered \code{sim_df} as a data.frame, with some rows kept and
some rows dropped. No filters applied if both \code{filter_keep} and
\code{filter_drop} are NULL.
}
\description{
\code{sim_filter_keep_or_drop_some} filters a melted similarity matrix to
remove or keep specified rows.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), 4, replace = TRUE),
  Metadata_type = sample(c("x", "y"), 4, replace = TRUE),
  x = rnorm(4),
  y = x + rnorm(4) / 100,
  z = y + rnorm(4) / 1000
)
annotation_cols <- c("Metadata_group", "Metadata_type")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
sim_df <- matric::sim_annotate(sim_df, row_metadata, annotation_cols)
filter_keep <- tibble::tibble(Metadata_group = "a", Metadata_type = "x")
filter_drop <- tibble::tibble(Metadata_group = "a", Metadata_type = "x")
matric::sim_filter_keep_or_drop_some(sim_df, row_metadata,
  filter_keep = filter_keep, filter_side = "left"
)
matric::sim_filter_keep_or_drop_some(sim_df, row_metadata,
  filter_drop = filter_drop, filter_side = "left"
)
}
