% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_wider.R
\name{sim_wider}
\alias{sim_wider}
\title{Widen a symmetric melted similarity matrix.}
\usage{
sim_wider(sim_df, annotation_column, primary_key_column)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{annotation_column}{character string specifying the column in \code{sim_df}
to use to annotate rows and columns}

\item{primary_key_column}{character string specifying the column in \code{sim_df}
to use to uniquely identify rows and columns}
}
\value{
data.frame of widened similarity matrix, with some attributes.
}
\description{
\code{sim_widen} widens a symmetric melted matrix.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b", "c", "d"), 100, replace = TRUE),
  x1 = rnorm(100),
  x2 = rnorm(100),
  x3 = rnorm(100),
  x4 = rnorm(100),
  x5 = rnorm(100)
)
population$Metadata_id <- seq(nrow(population))
metadata <- matric::get_annotation(population)
annotation_cols <- c("Metadata_group", "Metadata_id")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
sim_df <- matric::sim_annotate(sim_df, row_metadata, annotation_cols)
annotation_column <- "Metadata_group"
primary_key_column <- "Metadata_id"
res <- matric::sim_wider(sim_df, annotation_column, primary_key_column)
res
data.frame(id = rownames(res)) \%>\% dplyr::inner_join(attr(res, "map"))
}
