% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4c.biviph.R
\name{dens,biviph-method}
\alias{dens,biviph-method}
\title{Density method for bivariate inhomogeneous phase-type distributions}
\usage{
\S4method{dens}{biviph}(x, y)
}
\arguments{
\item{x}{An object of class \linkS4class{biviph}.}

\item{y}{A matrix of locations.}
}
\value{
A vector containing the joint density evaluations at the given locations.
}
\description{
Density method for bivariate inhomogeneous phase-type distributions
}
\examples{
under_bivph <- bivph(dimensions = c(3, 3))
obj <- biviph(under_bivph, gfun = c("weibull", "pareto"), gfun_pars = list(c(2), c(3)))
dens(obj, matrix(c(0.5, 1), ncol = 2))
}
