% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{rmatrixbetaII}
\alias{rmatrixbetaII}
\title{Matrix Beta II sampler}
\usage{
rmatrixbetaII(n, p, a, b, Theta1 = NULL, Theta2 = NULL, def = 1,
  checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{p}{dimension, a positive integer}

\item{a, b}{parameters of the distribution, positive numbers with constraints given
in Details}

\item{Theta1}{numerator noncentrality parameter, a positive semidefinite real
matrix of order \code{p}; setting it to \code{NULL} (default) is
equivalent to setting it to the zero matrix}

\item{Theta2}{denominator noncentrality parameter, a positive semidefinite real
matrix of order \code{p}; setting it to \code{NULL} (default) is
equivalent to setting it to the zero matrix}

\item{def}{\code{1} or \code{2}, the definition used; see Details}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{Theta1}
and \code{Theta2}}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples a matrix Beta type II distribution.
}
\details{
A Beta type II random matrix \eqn{V} is defined as follows.
Take two independent Wishart random matrices
\ifelse{html}{\out{S<sub>1</sub> ~ W<sub>p</sub>(2a,I<sub>p</sub>,&Theta;<sub>1</sub>)}}{\eqn{S_1 \sim \mathcal{W}_p(2a,I_p,\Theta_1)}}
and
\ifelse{html}{\out{S<sub>2</sub> ~ W<sub>p</sub>(2b,I<sub>p</sub>,&Theta;<sub>2</sub>)}}{\eqn{S_2 \sim \mathcal{W}_p(2b,I_p,\Theta_2)}}.
\itemize{
\item \strong{definition 1}:
\ifelse{html}{\out{V = S<sub>2</sub><sup>-&frac12;</sup>S<sub>1</sub>S<sub>2</sub><sup>-&frac12;</sup>}}{\eqn{V = S_2^{-\frac12}S_1S_2^{-\frac12}}}
\item \strong{definition 2}:
\ifelse{html}{\out{V = S<sub>1</sub><sup>&frac12;</sup>S<sub>2</sub><sup>-1</sup>S<sub>1</sub><sup>&frac12;</sup>}}{\eqn{V = S_1^\frac12 S_2^{-1}S_1^\frac12}}
}
In the central case, the two definitions yield the same distribution.
Under definition 2, the Beta type II distribution is related to the Beta
distribution by
\ifelse{html}{\out{V ~ U(I-U)<sup>-1</sup>}}{\eqn{V \sim U{(I-U)}^{-1}}}.

Parameters \code{a} and \code{b} are positive numbers that satisfy the
following constraints:
\itemize{
\item in any case, \code{b > (p-1)/2}
\item if \code{Theta1} is the null matrix and \code{a < (p-1)/2}, then
\code{a} must be half an integer
\item if \code{Theta1} is not the null matrix, \code{a >= (p-1)/2}}
}
\note{
The matrix variate Beta distribution of type II is usually defined only for
\eqn{a > (p-1)/2} and \eqn{b > (p-1)/2}. In this case, a random matrix \eqn{V}
generated from this distribution satisfies \eqn{V > 0}.
For an half integer \eqn{a \le (p-1)/2}, it satisfies \eqn{V \ge 0} and
\eqn{rank(V)=2a}.
}
\section{Warning}{

The issue described in the \strong{Warning} section of \code{\link{rmatrixbeta}}
also concerns \code{rmatrixbetaII}.
}

\examples{
Bsims <- rmatrixbetaII(10000, 3, 1, 1.5)
dim(Bsims) # 3 3 10000
}
