% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{organize_args}
\alias{organize_args}
\title{Organize binary arguments}
\usage{
organize_args(a, b, match_type = "all", fill)
}
\arguments{
\item{a}{the first argument to be organized}

\item{b}{the second argument to be organized}

\item{match_type}{one of \code{"all"}, \code{"matmult"}, \code{"none"}.
When both \code{a} and \code{b} are matrices,
"\code{all}" (the default) indicates that
rowtypes of \code{a} must match rowtypes of \code{b} and
coltypes of \code{a} must match coltypes of \code{b}.
If "\code{matmult}",
coltypes of \code{a} must match rowtypes of \code{b}.}

\item{fill}{a replacement value for \code{a} or \code{b} if either is missing or \code{NULL}.}
}
\value{
a list with two elements (named \code{a} and \code{b}) containing organized versions of the arguments
}
\description{
Organizes arguments of binary (2 arguments) \code{_byname} functions.
Actions performed are:
\itemize{
\item{if only one argument is a list, make the other argument also a list of equal length.}
\item{if both arguments are lists, ensure that they are same length.}
\item{if one argument is a matrix and the other is a constant, make the constant into a matrix.}
\item{ensures that row and column types match for \code{typematch_margins}.}
\item{ensures that list item names match if both \code{a} and \code{b} are lists;
no complaints are made if neither \code{a} nor \code{b} has names.}
\item{completes and sorts the matrices.}
}
}
