% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompletingMatrices.R
\name{sort_rows_cols}
\alias{sort_rows_cols}
\title{Sorts rows and columns of a matrix}
\usage{
sort_rows_cols(a, margin = c(1, 2), roworder = NA, colorder = NA)
}
\arguments{
\item{a}{a matrix or data frame whose rows and columns are to be sorted}

\item{margin}{specifies the subscript(s) in \code{a} over which sorting will occur.
\code{margin} has nearly the same semantic meaning as in \code{\link[base]{apply}}.
For rows only, give \code{1};
for columns only, give \code{2};
for both rows and columns, give \code{c(1,2)}, the default value.}

\item{roworder}{specifies the order for rows with default \code{sort(rownames(a))}.
If \code{NA} (the default), default sort order is used.
Unspecified rows are removed from the output, thus providing a way to delete rows from \code{a}.
Extraneous row names (row names in \code{roworder} that do not appear in \code{a}) are ignored.}

\item{colorder}{specifies the order for rows with default \code{sort(colnames(a))}.
If \code{NA} (the default), default sort order is used.
Unspecified columns are removed from the output, thus providing a way to delete columns from \code{a}.
Extraneous column names (column names in \code{colorder} that do not appear in \code{a}) are ignored.}
}
\value{
A modified version of \code{a} with sorted rows and columns
}
\description{
Checks that row names are unique and that column names are unique.
Then, sorts the rows and columns in a way that ensures
any other matrix with the same row and column names will have
the same order.
}
\details{
Default sort order is given by \code{base::sort()} with \code{decreasing = FALSE}.
}
\examples{
m <- matrix(c(1:6), nrow=3, dimnames = list(c("r3", "r5", "r1"), c("c4", "c2")))
sort_rows_cols(m)
sort_rows_cols(t(m))
sort_rows_cols(m, margin=1) # Sorts rows
sort_rows_cols(m, margin=2) # Sorts columns
v <- matrix(c(1:5), ncol=1, dimnames=list(rev(paste0("r", 1:5)), "c1")) # Column vector
sort_rows_cols(v)
sort_rows_cols(v, margin = 1) # Sorts rows
sort_rows_cols(v, margin = 2) # No effect: only one column
r <- matrix(c(1:4), nrow=1, dimnames=list("r1", rev(paste0("c", 1:4)))) # Row vector
sort_rows_cols(r) # Sorts columns
n <- matrix(c(1,2), nrow = 1, dimnames = list(NULL, c("c2", "c1"))) # No row name
sort_rows_cols(n) # Sorts columns, because only one row.
# Also works with lists
sort_rows_cols(list(m,m)) # Sorts rows and columns for both m's.
# Sort rows only for first one, sort rows and columns for second one.  
# Row order is applied to all m's.  Column order is natural.
sort_rows_cols(a = list(m,m), margin = 1, roworder = c("r5", "r3", "r1"))
# Columns are sorted as default, because no colorder is given.
# roworder is ignored. 
sort_rows_cols(a = list(m,m), margin = 2, roworder = c("r5", "r3", "r1"))
# Both columns and rows sorted, rows by the list, columns in natural order.
sort_rows_cols(a = list(m,m), margin = c(1,2), roworder = c("r5", "r3", "r1"))
}
