% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{cumsum_byname}
\alias{cumsum_byname}
\title{Cumulative sum that respects row and column names}
\usage{
cumsum_byname(a)
}
\arguments{
\item{a}{a number, list of numbers, matrix or list of matrices for which cumulative sum is desired}
}
\value{
a single number, list of numbers, a single matrix, or a list of matrices,
depending on the nature of \code{a}
}
\description{
Provides cumulative sums along a list or column of a data frame.
If \code{a} is a single number, \code{a} is returned.
If \code{a} is a list of numbers, a list representing the cumulative sum of the numbers is returned.
If \code{a} is a single matrix, \code{a} is returned.
If \code{a} is a list of matrices, a list representing the cumulative sum
of the matrices is returned.
In this case, each entry in the returned list is sum "by name,"
such that row and column names of the matrices are respected.
}
\details{
If cumulative sums are desired in the context of a data frame,
groups in the data frame are respected if \code{mutate} is used.
See examples.
}
\examples{
library(dplyr)
library(tibble)
m1 <- matrix(c(1), nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\% 
  setrowtype("row") \%>\% setcoltype("col")
m2 <- matrix(c(2), nrow = 1, ncol = 1, dimnames = list("r2", "c2")) \%>\% 
  setrowtype("row") \%>\% setcoltype("col")
m3 <- matrix(c(3), nrow = 1, ncol = 1, dimnames = list("r3", "c3")) \%>\% 
  setrowtype("row") \%>\% setcoltype("col")
cumsum_byname(list(m1, m2, m3))
# Groups are respected in the context of mutate.
tibble(grp = c("A", "A", "B"), m = list(m1, m2, m3)) \%>\% group_by(grp) \%>\% 
  mutate(m2 = cumsum_byname(m))
}
