% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{rowprods_byname}
\alias{rowprods_byname}
\title{Row products, sorted by name}
\usage{
rowprods_byname(a, colname = NA)
}
\arguments{
\item{a}{A matrix or list of matrices from which row products are desired.}

\item{colname}{The Name of the output column containing row products.}
}
\value{
A column vector of type \code{matrix} containing the row products of \code{a}
}
\description{
Calculates row products (the product of all elements in a row) for a matrix.
An optional \code{colname} for the resulting column vector can be supplied.
If \code{colname} is \code{NULL} or \code{NA} (the default),
the column name is set to the column type as given by \code{coltype(a)}.
}
\examples{
library(dplyr)
M <- matrix(c(1:6), ncol = 2, dimnames = list(paste0("i", 3:1), paste0("c", 1:2))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Products")
rowprods_byname(M)
rowprods_byname(M, "E.ktoe")
# This also works with lists
rowprods_byname(list(M, M))
rowprods_byname(list(M, M), "E.ktoe")
rowprods_byname(list(M, M), NA)
rowprods_byname(list(M, M), NULL)
DF <- data.frame(M = I(list()))
DF[[1,"M"]] <- M
DF[[2,"M"]] <- M
rowprods_byname(DF$M[[1]])
rowprods_byname(DF$M)
ans <- DF \%>\% mutate(rs = rowprods_byname(M))
ans
ans$rs[[1]]
# Nonsensical
\dontrun{rowprods_byname(NULL)}
}
