% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rename_to_piece_byname}
\alias{rename_to_piece_byname}
\title{Rename matrix rows and columns by piece of row or column names}
\usage{
rename_to_piece_byname(
  a,
  piece,
  margin = list(c(1, 2)),
  inf_notation = TRUE,
  notation = list(RCLabels::notations_list),
  choose_most_specific = FALSE,
  prepositions = list(RCLabels::prepositions_list)
)
}
\arguments{
\item{a}{A matrix or list of matrices whose rows or columns will be renamed.}

\item{piece}{A character string indicating which piece of the row or column names to retain,
one of "noun", "pps", "pref" or "suff", or a preposition,
indicating which part of the row or column name is to be retained.}

\item{margin}{As a character, the row type or column type to be renamed.
As an integer, the margin to be renamed.
Default is \code{c(1, 2)}, meaning that both
rows (\code{margin = 1}) and columns (\code{margin = 2})
will be renamed.}

\item{inf_notation}{A boolean that tells whether to infer notation.
Default is \code{TRUE}.}

\item{notation}{The notation used for row and column labels.
Default is \code{list(RCLabels::notations_list)}.
The default value is wrapped in a list,
because \code{RCLabels::notations_list} is, itself, a list.
If \code{notation} is not a list, unexpected behavior can result.
See \code{RCLabels}.}

\item{choose_most_specific}{A boolean that indicates whether the most-specific notation
will be inferred when more than one of \code{notation} matches
a row or column label
and \code{allow_multiple = FALSE}.
When \code{FALSE}, the first matching notation in \code{notations}
is returned when \code{allow_multiple = FALSE}.
Default is \code{FALSE}.}

\item{prepositions}{Prepositions that can be used in the row and column label.
Default is \code{RCLabels::prepositions_list}.}
}
\value{
A version of \code{a} with renamed rows and columns.
}
\description{
It can be convenient to rename rows or columns of matrices
based on retaining only a piece of the row and/or column names.
This function provides that capability.
}
\details{
Internally, this function finds pieces of row and column names
via the \code{RCLabels} package.
\code{piece} can be anything that \code{RCLabels::get_piece()} understands.
Note that \code{margin} can be either an integer vector or
a character vector.
If \code{margin} is a character vector,
it is interpreted as a row or column type, and
\code{margin_from_types_byname()} is called internally to
resolve the integer margins of interest.

Note that if row and/or column type are present,
the row and/or column type are also renamed according to \code{piece}.
This behavior is usually helpful.
For example,
if the prefix is requested (\code{piece = "pref"}) and
the row/coltype is a single word
that does not conform to the notation,
the entire row/coltype string is retained.
However, if the suffix is requested (\code{piece = "suff"}) and
the row/coltype is a single word
that does not conform to the notation,
an empty string ("") is returned.
In those circumstances,
the caller is responsible for
setting the row/coltype if an empty string ("")
is not desired.
See the examples for details.
}
\examples{
m <- matrix(c(1, 2, 
              3, 4, 
              5, 6), nrow = 3, byrow = TRUE, 
            dimnames = list(c("a -> b", "r2", "r3"), c("a -> b", "c -> d")))
m
rename_to_piece_byname(m, piece = "pref", notation = RCLabels::arrow_notation)
m2 <- m \%>\%
  setrowtype("rows") \%>\% setcoltype("cols")
m2
# In this example, 
# rowtype and coltype are unchanged, because the 
# whole string is considered to be the prefix.
rename_to_piece_byname(m2, piece = "pref", margin = "rows",
                       notation = RCLabels::arrow_notation)
# Here, the rowtype is set to the empty string ("")
# because there is no suffix for the type of the "rows" margin.
rename_to_piece_byname(m2, piece = "suff", margin = "rows",
                       notation = RCLabels::arrow_notation)
m3 <- m2 |> 
  setrowtype("Industry -> Product")
m3
# Note that the rowtype becomes the prefix for the rowtype, 
# in this example "Industry".
rename_to_piece_byname(m3, piece = "pref", margin = 1,
                       notation = RCLabels::arrow_notation)
# And when a suffix is present, 
# the rowtype becomes the suffix, 
# in this example "Product".
rename_to_piece_byname(m3, piece = "suff", margin = 1,
                       notation = RCLabels::arrow_notation)
}
