% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{max_stable_prcomp}
\alias{max_stable_prcomp}
\title{Calculate max-stable PCA with dimension p for given dataset}
\usage{
max_stable_prcomp(data, p, s = 3, n_initial_guesses = 150, norm = "l1", ...)
}
\arguments{
\item{data, }{array or data.frame of n observations of d variables
with unit Frechet margins. The max-stable PCA is fitted to
reconstruct this dataset with a rank p approximation.}

\item{p, }{integer between 1 and ncol(data). Determines
the dimension of the encoded state, i.e. the number of max-linear
combinations in the compressed representation.}

\item{s}{(default = 3), numeric greater than 0. Hyperparameter for the
stable tail dependence estimator used in tn the calculation.}

\item{n_initial_guesses}{number of guesses to choose a valid initial value
for optimization from. This procedure uses a pseudo random number generator so
setting a seed is necessary for reproducibility.}

\item{norm}{(delfault "l1") which norm to use for the spectral measure estimator, currently only l1 and sup norm "linfty" are available.}

\item{...}{additional parameters passed to \code{link{nloptr::slsqp()}}}
}
\value{
object of class max_stable_prcomp with slots
p, inserted value of dimension,
decoder_matrix, an array of shape (d,p), where the columns represent the basis of the max-linear space for the reconstruction.
encoder_matrix, an array of shape (p,d), where the rows represent the loadings as max-linear combinations for the compressed representation.
reconstr_matrix, an array of shape (d,d), where the matrix is the mapping of the data to the reconstruction used for the distance minimization.
loss_fctn_value, float representing the final loss function value of the fit.
optim_conv_status, integer indicating the convergence of the optimizer if greater than 0.
}
\description{
Find an optimal encoding of data of extremes using max-linear combinations
by a distance minimization approach. Can be used to check if the data
follows approximately a generalized max-linear model.
For details on the statistical procedure it is advised to
consult the articles "F. Reinbott, A. Janßen, Principal component analysis for max-stable distributions (https://arxiv.org/abs/2408.10650)"
and "M.Schlather F. Reinbott, A semi-group approach to Principal Component Analysis (https://arxiv.org/abs/2112.04026)".
}
\examples{
# generate some data with the desired margins
dat <- matrix(evd::rfrechet(300), 100, 3)
maxPCA <- max_stable_prcomp(dat, 2)

# look at summary to obtain further information about 
# loadings the space spanned and loss function
summary(maxPCA)

# transfrom data to compressed representation
# for a representation that is p-dimensional,
# preserves the max-stable structure and is numeric solution to 
# optimal reconstruction.
compr <- compress(maxPCA, dat)

# For visual examination reconstruct original vector from compressed representation
rec <- reconstruct(maxPCA, compr)
}
