% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_base.R
\name{add_base.mcgf_rs}
\alias{add_base.mcgf_rs}
\title{Add base model outputted from \code{\link[=fit_base]{fit_base()}} to an \code{mcgf_rs} object.}
\usage{
\method{add_base}{mcgf_rs}(x, fit_base_ls, fit_s_ls, fit_t_ls, sep = FALSE, old = FALSE, ...)
}
\arguments{
\item{x}{An mcgf_rs` object.}

\item{fit_base_ls}{Output from the \code{\link[=fit_base]{fit_base()}} function.}

\item{fit_s_ls}{Pure spatial model outputted from the \code{\link[=fit_base]{fit_base()}} function.
Used only when \code{sep = TRUE}.}

\item{fit_t_ls}{Pure temporal model outputted from the \code{\link[=fit_base]{fit_base()}}
function. Used only when \code{sep = TRUE}.}

\item{sep}{Logical; TRUE if spatial and temporal models are fitted
separately.}

\item{old}{Logical; TRUE if the old base model needs to be kept. The lag and
horizon of the new model are assumed to be the same as that of the old model.}

\item{...}{Additional arguments. Not in use.}
}
\value{
\code{x} with newly added attributes of the base model.
}
\description{
Add base model outputted from \code{\link[=fit_base]{fit_base()}} to an \code{mcgf_rs} object.
}
\details{
After fitting the base model by \code{\link[=fit_base]{fit_base()}}, the results can be added to
\code{x} by \code{\link[=add_base]{add_base()}}. To supply the base model directly, use \code{\link{base<-}} to
add the base model; the value must contain the same output as
\code{\link[=add_base.mcgf]{add_base.mcgf()}} or \code{\link[=add_base.mcgf_rs]{add_base.mcgf_rs()}}.
}
\examples{
data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
sim2_mcgf <- add_acfs(sim2_mcgf, lag_max = 5)
sim2_mcgf <- add_ccfs(sim2_mcgf, lag_max = 5)

# Fit a regime-switching pure spatial model
fit_spatial <-
    fit_base(
        sim2_mcgf,
        lag_ls = 5,
        model_ls = "spatial",
        par_init_ls = list(c(c = 0.000001, gamma = 0.5)),
        par_fixed_ls = list(c(nugget = 0))
    )

# Fit a regime-switching pure temporal model
fit_temporal <-
    fit_base(
        sim2_mcgf,
        lag_ls = 5,
        model_ls = "temporal",
        par_init_ls = list(
            list(a = 0.8, alpha = 0.8),
            list(a = 0.5, alpha = 0.5)
        )
    )

# Store the fitted models to 'sim2_mcgf'
sim2_mcgf <- add_base(sim2_mcgf,
    fit_s_ls = fit_spatial,
    fit_t_ls = fit_temporal,
    sep = TRUE
)

# Fit a regime-switching separable model
fit_sep <- fit_base(
    sim2_mcgf,
    lag_ls = 5,
    model_ls = "sep",
    par_init_ls = list(list(
        c = 0.000001,
        gamma = 0.5,
        a = 0.5,
        alpha = 0.5
    )),
    par_fixed_ls = list(c(nugget = 0))
)

# Store the newly fitted model, and keep the old fit
sim2_mcgf <- add_base(sim2_mcgf, fit_base_ls = fit_sep, old = TRUE)
model(sim2_mcgf, model = "base", old = TRUE)
}
\seealso{
Other functions on fitting an mcgf_rs: 
\code{\link{add_lagr.mcgf_rs}()},
\code{\link{fit_base.mcgf_rs}()},
\code{\link{fit_lagr.mcgf_rs}()},
\code{\link{krige.mcgf_rs}()}
}
\concept{functions on fitting an mcgf_rs}
