% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgf_sim.R
\name{mcgf_sim}
\alias{mcgf_sim}
\title{Simulate Markov chain Gaussian field}
\usage{
mcgf_sim(
  N,
  base = c("sep", "fs"),
  lagrangian = c("none", "lagr_tri", "lagr_askey"),
  par_base,
  par_lagr,
  lambda,
  dists,
  sd = 1,
  lag = 1,
  scale_time = 1,
  horizon = 1,
  init = 0,
  mu_c = 0,
  mu_p = 0,
  return_all = FALSE
)
}
\arguments{
\item{N}{Sample size.}

\item{base}{Base model, \code{sep} or \code{fs} for now.}

\item{lagrangian}{Lagrangian model, "none" or \code{lagr_tri} for now.}

\item{par_base}{Parameters for the base model (symmetric).}

\item{par_lagr}{Parameters for the Lagrangian model.}

\item{lambda}{Weight of the Lagrangian term, \eqn{\lambda\in[0, 1]}.}

\item{dists}{Distance matrices or arrays.}

\item{sd}{Standard deviation for each location.}

\item{lag}{Time lag.}

\item{scale_time}{Scale of time unit, default is 1. \code{lag} is divided by
\code{scale_time}.}

\item{horizon}{Forecast horizon, default is 1.}

\item{init}{Initial samples, default is 0.}

\item{mu_c, mu_p}{Means of current and past.}

\item{return_all}{Logical; if TRUE the joint covariance matrix, arrays of
distances and time lag are returned.}
}
\value{
Simulated Markov chain Gaussian field with user-specified covariance
structure. The simulation is done by kriging. The output data is in
space-wide format. \code{dists} must contain \code{h} for symmetric models, and \code{h1}
and \code{h2} for general stationary models. \code{horizon} controls forecasting
horizon. \code{sd}, \code{mu_c}, \code{mu_p}, and \code{init} must be vectors of appropriate
sizes.
}
\description{
Simulate Markov chain Gaussian field
}
\examples{
par_s <- list(nugget = 0.5, c = 0.01, gamma = 0.5)
par_t <- list(a = 1, alpha = 0.5)
par_base <- list(par_s = par_s, par_t = par_t)
par_lagr <- list(v1 = 5, v2 = 10)
h1 <- matrix(c(0, 5, -5, 0), nrow = 2)
h2 <- matrix(c(0, 8, -8, 0), nrow = 2)
h <- sqrt(h1^2 + h2^2)
dists <- list(h = h, h1 = h1, h2 = h2)

set.seed(123)
X <- mcgf_sim(
    N = 1000, base = "sep", lagrangian = "lagr_tri", lambda = 0.5,
    par_base = par_base, par_lagr = par_lagr, dists = dists
)
plot.ts(X)

}
\seealso{
Other simulations of Markov chain Gaussian fields: 
\code{\link{mcgf_rs_sim}()}
}
\concept{simulations of Markov chain Gaussian fields}
