% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMM_finance.R
\name{GMMlogreturn}
\alias{GMMlogreturn}
\alias{summary.GMMlogreturn}
\title{Modeling log-returns distribution via Gaussian Mixture Models}
\usage{
GMMlogreturn(y, ...)

\method{summary}{GMMlogreturn}(object, ...)
}
\arguments{
\item{y}{A numeric vector providing the log-returns of a financial stock.}

\item{\dots}{Further arguments passed to \code{\link[=densityMclustBounded]{densityMclustBounded()}}. For a full
description of available arguments see the corresponding help page.}

\item{object}{An object of class \code{'GMMlogreturn'}.}
}
\value{
Returns an object of class \code{'GMMlogreturn'}.
}
\description{
Gaussian mixtures for modeling the distribution of financial log-returns.
}
\details{
Let \eqn{P_t} be the price of a financial stock for the current time frame
(day for instance), and \eqn{P_{t-1}} the price of the previous time frame.
The log-return at time \eqn{t} is defined as:
\deqn{ 
  y_t = \log( \frac{P_t}{P_{t-1}} ) 
}
A univariate heteroscedastic GMM using Bayesian regularization
(as described in \code{\link[mclust:priorControl]{mclust::priorControl()}}) is fitted to the observed
log-returns. The number of mixture components is automatically selected
by BIC, unless specified with the optional \code{G} argument.
}
\examples{
set.seed(123)
z = sample(1:2, size = 250, replace = TRUE, prob = c(0.8, 0.2))
y = double(length(z))
y[z == 1] = rnorm(sum(z == 1), 0, 1)
y[z == 2] = rnorm(sum(z == 2), -0.5, 2)
GMM = GMMlogreturn(y)
summary(GMM)
y0 = extendrange(GMM$data, f = 0.1)
y0 = seq(min(y0), max(y0), length = 1000)
plot(GMM, what = "density", data = y, xlab = "log-returns",
     breaks = 21, col = 4, lwd = 2)

}
\references{
Scrucca L. (2024) Entropy-based volatility analysis of financial
log-returns using Gaussian mixture models. Unpublished manuscript.
}
\seealso{
\code{\link[=VaR.GMMlogreturn]{VaR.GMMlogreturn()}}, \code{\link[=ES.GMMlogreturn]{ES.GMMlogreturn()}}.
}
\author{
Luca Scrucca
}
