% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclustcomp.R
\name{mclustcomp}
\alias{mclustcomp}
\title{Measures for Comparing Clusterings}
\usage{
mclustcomp(x, y, types = "all", tversky.param = list())
}
\arguments{
\item{x, y}{vectors of clustering labels}

\item{types}{\code{"all"} for returning scores for every available measure.
Either a single score name or a vector of score names can be supplied. See the section
for the list of the methods for details.}

\item{tversky.param}{a list of parameters for Tversky index; \code{alpha} and \code{beta} for
weight parameters, and \code{sym}, a logical where \code{FALSE} stands for original method, \code{TRUE}
for a revised variant to symmetrize the score. Default (alpha,beta)=(1,1).}
}
\value{
a data frame with columns \code{types} and corresponding \code{scores}.
}
\description{
Given two partitions \eqn{C_1} and \eqn{C_2}, it returns community comparison scores
corresponding with a set of designated methods. Note that two label vectors should be
of same length having either numeric or factor type. Currently we have 3 classes of methods
depending on methodological philosophy behind each. See below for the taxonomy.
}
\section{Category 1. Counting Pairs}{

\tabular{cl}{
TYPE \tab FULL NAME \cr
\code{'adjrand'}  \tab \href{https://en.wikipedia.org/wiki/Rand_index}{Adjusted Rand index}.\cr
\code{'chisq'}    \tab \href{https://en.wikipedia.org/wiki/Chi-squared_test}{Chi-Squared Coefficient}.\cr
\code{'fmi'}      \tab \href{https://en.wikipedia.org/wiki/Fowlkes-Mallows_index}{Fowlkes-Mallows index}.\cr
\code{'jaccard'}  \tab \href{https://en.wikipedia.org/wiki/Jaccard_index}{Jaccard index}.\cr
\code{'mirkin'}   \tab Mirkin Metric, or Equivalence Mismatch Distance. \cr
\code{'overlap'}  \tab \href{https://en.wikipedia.org/wiki/Overlap_coefficient}{Overlap Coefficient}, or Szymkiewicz-Simpson coefficient.\cr
\code{'pd'}       \tab Partition Difference.\cr
\code{'rand'}     \tab \href{https://en.wikipedia.org/wiki/Rand_index}{Rand Index}.\cr
\code{'sdc'}      \tab \href{https://en.wikipedia.org/wiki/Sorensen-Dice_coefficient}{Sørensen–Dice Coefficient}.\cr
\code{'smc'}      \tab \href{https://en.wikipedia.org/wiki/Simple_matching_coefficient}{Simple Matching Coefficient}.\cr
\code{'tanimoto'} \tab \href{https://en.wikipedia.org/wiki/Jaccard_index}{Tanimoto index}.\cr
\code{'tversky'}  \tab \href{https://en.wikipedia.org/wiki/Tversky_index}{Tversky index}. Tanimoto Coefficient and Dice's coefficient are special cases with (alpha,beta) = (1,1) and (0.5,0.5), respectively.\cr
\code{'wallace1'} \tab Wallace Criterion Type 1.\cr
\code{'wallace2'} \tab Wallace Criterion Type 2.
}
}

\section{Category 2. Set Overlaps/Matching}{

\tabular{cl}{
TYPE \tab FULL NAME \cr
\code{'f'}   \tab F-Measure. \cr
\code{'mhm'} \tab Meila-Heckerman Measure. \cr
\code{'mmm'} \tab Maximum-Match Measure. \cr
\code{'vdm'} \tab Van Dongen Measure.
}
}

\section{Category 3. Information Theory}{

\tabular{cl}{
TYPE \tab FULL NAME \cr
\code{'jent'} \tab \href{https://en.wikipedia.org/wiki/Joint_entropy}{Joint Entropy} \cr
\code{'mi'}   \tab Mutual Information. \cr
\code{'nmi1'} \tab \href{https://en.wikipedia.org/wiki/Mutual_information}{Normalized Mutual Information} by Strehl and Ghosh. \cr
\code{'nmi2'} \tab \href{https://en.wikipedia.org/wiki/Mutual_information}{Normalized Mutual Information} by Fred and Jain. \cr
\code{'nmi3'} \tab Normalized Mutual Information by Danon et al. \cr
\code{'nvi'}  \tab Normalized Variation of Information. \cr
\code{'vi'}   \tab \href{https://en.wikipedia.org/wiki/Variation_of_information}{Variation of Information}.
}
}

\examples{
## example 1. compare two identical clusterings
x = sample(1:5,20,replace=TRUE) # label from 1 to 5, 10 elements
y = x                           # set two labels x and y equal
mclustcomp(x,y)                 # show all results

## example 2. selection of a few methods
z = sample(1:4,20,replace=TRUE)           # generate a non-trivial clustering
cmethods = c("jaccard","tanimoto","rand") # select 3 methods
mclustcomp(x,z,types=cmethods)            # test with the selected scores

## example 3. tversky.param
tparam = list()                           # create an empty list
tparam$alpha = 2
tparam$beta  = 3
tparam$sym   = TRUE
mclustcomp(x,z,types="tversky")           # default set as Tanimoto case.
mclustcomp(x,z,types="tversky",tversky.param=tparam)


}
\references{
\insertRef{strehl_cluster_2003}{mclustcomp}

\insertRef{meila_comparing_2007}{mclustcomp}

\insertRef{goos_comparing_2003}{mclustcomp}

\insertRef{wagner_comparing_2007}{mclustcomp}

\insertRef{albatineh_similarity_2006}{mclustcomp}

\insertRef{mirkin_eleven_2001}{mclustcomp}

\insertRef{rand_objective_1971}{mclustcomp}

\insertRef{kuncheva_using_2004}{mclustcomp}

\insertRef{fowlkes_method_1983}{mclustcomp}

\insertRef{dongen_performance_2000}{mclustcomp}

\insertRef{jaccard_distribution_1912}{mclustcomp}

\insertRef{li_combining_2010}{mclustcomp}

\insertRef{larsen_fast_1999}{mclustcomp}

\insertRef{meila_experimental_2001}{mclustcomp}

\insertRef{cover_elements_2006}{mclustcomp}

\insertRef{ana_robust_2003}{mclustcomp}

\insertRef{wallace_comment_1983}{mclustcomp}

\insertRef{simpson_mammals_1943}{mclustcomp}

\insertRef{dice_measures_1945}{mclustcomp}

\insertRef{segaran_programming_2007}{mclustcomp}

\insertRef{tversky_features_1977}{mclustcomp}

\insertRef{danon_comparing_2005}{mclustcomp}

\insertRef{lancichinetti_detecting_2009}{mclustcomp}
}
