% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sampler_control}
\alias{sampler_control}
\title{Set computational options for the sampling algorithms}
\usage{
sampler_control(add.outer.R = NULL, recompute.e = TRUE, CG = NULL)
}
\arguments{
\item{add.outer.R}{whether to add the outer product of the constraint matrix for a better conditioned solve system
for blocks. This is done by default when using blocked Gibbs sampling for blocks with constraints.}

\item{recompute.e}{when \code{FALSE}, residuals or linear predictors are only computed at the start of the simulation.
This may give a modest speedup but in some cases may be less accurate due to round-off error accumulation.
Default is \code{TRUE}.}

\item{CG}{use a conjugate gradient iterative algorithm instead of Cholesky updates for sampling
the model's coefficients. This must be a list with possible components \code{max.it},
\code{stop.criterion}, \code{verbose}, \code{preconditioner} and \code{scale}.
See the help for function \code{\link{CG_control}}, which can be used to specify these options.
Conjugate gradient sampling is currently an experimental feature that can be used for
blocked Gibbs sampling but with some limitations.}
}
\value{
A list with specified computational options that is used to set up the sampling functions.
}
\description{
Set computational options for the sampling algorithms
}
