% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_bart.R
\name{bart}
\alias{bart}
\title{Create a model component object for a BART (Bayesian Additive Regression Trees)
component in the linear predictor}
\usage{
bart(formula, X = NULL, name = "", debug = FALSE, ...)
}
\arguments{
\item{formula}{a formula specifying the predictors to be used in the BART
model component. Variable names are looked up in the data frame
passed as \code{data} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{X}{a design matrix can be specified directly, as an alternative
to the creation of one based on \code{formula}. If \code{X} is
specified \code{formula} is ignored.}

\item{name}{the name of the model component. This name is used in the output of the
MCMC simulation function \code{\link{MCMCsim}}. By default the name will be 'bart'
with the number of the model term attached.}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}

\item{...}{parameters passed to \code{\link[dbarts]{dbarts}}.}
}
\value{
an object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component. Intended
 for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the
\code{formula} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}. It creates a BART term in the
model's linear predictor. To use this model component one needs
to have R package \pkg{dbarts} installed.
}
\references{
H.A. Chipman, E.I. Georgea and R.E. McCulloch (2010).
   BART: Bayesian additive regression trees.
   The Annals of Applied Statistics 4(1), 266-298.
}
