% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_difference}
\alias{h_difference}
\title{Compute Difference for Bland-Altman}
\usage{
h_difference(x, y, type)
}
\arguments{
\item{x}{(\code{numeric})\cr reference method.}

\item{y}{(\code{numeric})\cr test method.}

\item{type}{(\code{integer})\cr integer specifying a specific difference for Bland-Altman
(default is 3). Possible choices are:
1 - difference with X vs. Y-X (absolute differences).
2 - difference with X vs. (Y-X)/X (relative differences).
3 - difference with 0.5*(X+Y) vs. Y-X (absolute differences).
4 - difference with 0.5*(X+Y) vs. (Y-X)/X (relative differences).
5 - difference with 0.5*(X+Y) vs. (Y-X)/(0.5*(X+Y)) (relative differences).}
}
\value{
a matrix contains the x and y measurement data and corresponding difference.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function computes the difference with specific type.
}
\examples{
h_difference(x = c(1.1, 1.2, 1.5), y = c(1.2, 1.3, 1.4), type = 5)
}
