% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotseries.R
\name{plotseries}
\alias{plotseries}
\title{Create plot series object based on data, plot type and parameters}
\usage{
plotseries(
  data,
  type,
  cgroup = NULL,
  col = NULL,
  opacity = 1,
  colmap = "default",
  labels = NULL
)
}
\arguments{
\item{data}{data to make the plot for (vector, matrix or data frame).}

\item{type}{type of the plot.}

\item{cgroup}{vector with values used to create a color grouping of the series instances.}

\item{col}{color to show the series on plot with (user defined).}

\item{opacity}{opacity of the colors (between 0 and 1).}

\item{colmap}{colormap name to generate color/colors if they are not specified by user. See
\code{link{mdaplot.getColors}} for details.}

\item{labels}{either vector with labels for the series instances or string ("names", "values", or "indices")
if labels should be generated automatically.}
}
\description{
The `plotseries` object contains all necessary paremeters to create main plots
from data values, including values for x and y, correct handling of excluded rows
and columns, color grouping (if any), limits and labels.

If both `col` and `cgroup` are specified, `cgroup` will be ignored.

Labels can be either provided by user or generated automatically based on values, names or
indices of data rows and columns. If series is made for scatter plot `type="p"` then labels
are required for each row of the original dataset. Otherwise (for line, bar and errobar plot)
labels correspond to data columns (variables).

The object has the following plotting methods once created:
\code{\link{plotScatter}}
\code{\link{plotLines}}
\code{\link{plotBars}}
\code{\link{plotDensity}}
\code{\link{plotErrorbars}}
}
