% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca.cal}
\alias{pca.cal}
\title{PCA model calibration}
\usage{
pca.cal(x, ncomp, center, scale, method, exclcols = NULL, exclrows = NULL,
  cv, rand, lim.type, alpha, gamma, info)
}
\arguments{
\item{x}{matrix with data values}

\item{ncomp}{number of principal components to calculate}

\item{center}{logical, do mean centering or not}

\item{scale}{logical, do standardization or not}

\item{method}{algorithm for compiting PC space (only 'svd' and 'nipals' are supported so far)}

\item{exclcols}{columns to be excluded from calculations (numbers, names or vector with logical values)}

\item{exclrows}{rows to be excluded from calculations (numbers, names or vector with logical values)}

\item{cv}{number of segments for random cross-validation (1 for full cross-validation).}

\item{rand}{vector with parameters for randomized PCA methods (if NULL, conventional PCA is used instead)}

\item{lim.type}{which method to use for calculation of critical limits for residuals (see details for \code{pca})}

\item{alpha}{significance level for calculating critical limits for T2 and Q residuals.}

\item{gamma}{significance level for calculating outlier limits for T2 and Q residuals.}

\item{info}{a short text line with model description.}
}
\value{
an object with calibrated PCA model
}
\description{
Calibrates (builds) a PCA model for given data and parameters
}
