/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.definitions;

import javax.swing.JInternalFrame;
import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.data.DataFile;
import multidendrograms.data.ExternalData;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.types.MethodType;
import multidendrograms.types.ProximityType;

public class Config {
    private HierarchicalClustering clustering = null;
    private ExternalData externalData;
    private SettingsInfo settings;
    private JInternalFrame dendroFrame;
    private DataFile dataFile;

    public Config(SettingsInfo settingsInfo) {
        this.settings = settingsInfo;
    }

    public void setExternalData(ExternalData externalData) {
        this.externalData = externalData;
    }

    public ExternalData getExternalData() {
        return this.externalData;
    }

    public String[] getNames() {
        return this.externalData.getNames();
    }

    public SettingsInfo getSettingsInfo() {
        return this.settings;
    }

    public void setDendrogramFrame(JInternalFrame jInternalFrame) {
        this.dendroFrame = jInternalFrame;
    }

    public JInternalFrame getDendrogramFrame() {
        return this.dendroFrame;
    }

    public void setDataFile(DataFile dataFile) {
        this.dataFile = new DataFile(dataFile);
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public ProximityType getProximityType() {
        return this.settings.getProximityType();
    }

    public boolean isDistance() {
        return this.settings.getProximityType().equals((Object)ProximityType.DISTANCE);
    }

    public int getPrecision() {
        return this.settings.getPrecision();
    }

    public MethodType getMethod() {
        return this.settings.getMethod();
    }

    public double getMethodParameter() {
        return this.settings.getMethodParameter();
    }

    public boolean isWeighted() {
        return this.settings.isWeighted();
    }

    public void setHierarchicalClustering(HierarchicalClustering hierarchicalClustering) {
        this.clustering = hierarchicalClustering;
    }

    public HierarchicalClustering getHierarchicalClustering() {
        return this.clustering;
    }

    public Dendrogram getRoot() {
        return this.clustering.getRoot();
    }

    public DendrogramOrientation getDendrogramOrientation() {
        return this.settings.getDendrogramOrientation();
    }

    public void setDendrogramOrientation(DendrogramOrientation dendrogramOrientation) {
        this.settings.setDendrogramOrientation(dendrogramOrientation);
    }

    public LabelOrientation getNodeNameOrientation() {
        return this.settings.getNodeNameOrientation();
    }

    public double getRadius() {
        return 5.0;
    }

    public double getAxisMinValue() {
        return this.settings.getAxisMinValue();
    }

    public double getAxisMaxValue() {
        return this.settings.getAxisMaxValue();
    }

    public double getAxisIncrement() {
        return this.settings.getAxisIncrement();
    }

    public int getAxisTicks() {
        return this.settings.getAxisTicks();
    }

    public int getAxisLabelDecimals() {
        return this.settings.getAxisLabelDecimals();
    }
}

