/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.children;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Formats;
import multidendrograms.dendrogram.DendrogramMeasures;
import multidendrograms.dendrogram.UltrametricMatrix;
import multidendrograms.initial.Language;
import multidendrograms.initial.MethodName;

public class DendrogramMeasuresBox
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;

    public DendrogramMeasuresBox(UltrametricMatrix ultrametricMatrix, Config config) {
        this.initComponents(ultrametricMatrix, config);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void initComponents(UltrametricMatrix ultrametricMatrix, Config config) {
        this.setDefaultCloseOperation(2);
        this.setTitle(Language.getLabel(123));
        this.setModal(false);
        this.setName("DendrogramCharacteristicsBox");
        this.setResizable(false);
        JLabel jLabel = Formats.getFormattedTitleItalicsLabel(config.getDataFile().getName() + " - " + MethodName.toName(config.getMethod()));
        JLabel jLabel2 = Formats.getFormattedLabel("");
        JLabel jLabel3 = Formats.getFormattedBoldLabel("Normalized Tree Balance");
        JLabel jLabel4 = Formats.getFormattedBoldLabel("Cophenetic Correlation Coefficient");
        JLabel jLabel5 = Formats.getFormattedBoldLabel("Normalized Mean Squared Error");
        JLabel jLabel6 = Formats.getFormattedBoldLabel("Normalized Mean Absolute Error");
        JLabel jLabel7 = Formats.getFormattedBoldLabel("Space Distortion");
        DendrogramMeasures dendrogramMeasures = new DendrogramMeasures(config.getExternalData().getProximityMatrix(), config.getRoot(), ultrametricMatrix.getMatrix());
        JLabel jLabel8 = Formats.getFormattedLabel(dendrogramMeasures.getTreeBalance());
        JLabel jLabel9 = Formats.getFormattedLabel(dendrogramMeasures.getCopheneticCorrelation());
        JLabel jLabel10 = Formats.getFormattedLabel(dendrogramMeasures.getSquaredError());
        JLabel jLabel11 = Formats.getFormattedLabel(dendrogramMeasures.getAbsoluteError());
        JLabel jLabel12 = Formats.getFormattedLabel(dendrogramMeasures.getSpaceDistortion());
        JButton jButton = Formats.getFormattedButton(Language.getLabel(60));
        jButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(jLabel).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel3).addComponent(jLabel2).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6).addComponent(jLabel7)).addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel8).addComponent(jLabel2).addComponent(jLabel9).addComponent(jLabel10).addComponent(jLabel11).addComponent(jLabel12)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.CENTER, groupLayout.createSequentialGroup().addComponent(jButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jLabel).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel12)).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel7))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(jButton).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

