% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_device_events.R
\name{deviceevent}
\alias{deviceevent}
\title{MD-PMS Device Event Data Frame}
\usage{
deviceevent(data_frame, time, device_hierarchy, event_hierarchy,
  key = NULL, covariates = NULL, descriptors = NULL,
  implant_days = NULL)
}
\arguments{
\item{data_frame}{The input data frame requiring components specified in the
remaining arguments.}

\item{time}{Character name of date variable in \code{data_frame}
corresponding to the event. Class must be Date, POSIXt, or character.

Example: \code{"event_date"}}

\item{device_hierarchy}{Vector of character variable names representing the
device hierarchy in \code{data_frame}. Vector ordering is lowest level first,
most general level last.

Example: \code{c("Version", "Device", "ProductLine")}}

\item{event_hierarchy}{Vector of character variable names representing the
event hierarchy in \code{data_frame}. Vector ordering is most specific event
category first, most broad event category last.

Example: \code{c("Event Code", "Event Group")}}

\item{key}{Character name of (uniquely identifying) primary key variable in
\code{data_frame}. Class must be character or numeric.

Example: \code{"key_ID"}

Default: \code{NULL} will create a key variable.}

\item{covariates}{Vector of character variable names representing the
desired covariates to retain \code{"_all_"} includes all covariates, assumed
to be remaining variables in \code{data_frame} not already specified in
\code{key}, \code{time}, \code{device_hierarchy}, or \code{event_hierarchy}.
It is recommended that covariates are categorical.

Example: \code{c("Reporter", "City", "Country")}

Default: \code{NULL} includes no covariates.}

\item{descriptors}{Vector of character variable names representing additional
descriptive variables that will not be used in any analyses but may be
recalled or displayed later during individual device-event review.
\code{"_all_"} includes all remaining variables in \code{data_frame} not
already specified in \code{key}, \code{time}, \code{device_hierarchy},
\code{event_hierarchy}, or \code{covariates}. Typical descriptors are
free text or high-dimensional categoricals.

Example: \code{c("Description", "Unique Device Identifier")}

Default: \code{NULL} includes no descriptors.}

\item{implant_days}{Character name of integer variable in \code{data_frame}
representing the days in vivo of the device at the time of the event
(\code{time}). More generally, this represents days of exposure of the device
at the time of the event.

Example: \code{"Implant Days"}. For example, a value of \code{45} indicates
that the implant was in vivo for 45 days at the time of the event.

Default: \code{NULL} indicates this variable will not be used.}
}
\value{
A standardized MD-PMS data frame of class \code{mds_de}.
Rows are deduplicated. Attributes are as follows:
\describe{
  \item{key}{Original variable name for \code{key}}
  \item{time}{Original variable name for \code{time}}
  \item{device_hierarchy}{Vector of original variable names for
  \code{device_hierarchy} with converted variable names correspondingly
  named.}
  \item{event_hierarchy}{Vector of original variable names for
  \code{event_hierarchy} with converted variable names correspondingly
  named.}
  \item{covariates}{Vector of original variable names for
  \code{covariates} with converted variable names correspondingly
  named.}
  \item{descriptors}{Vector of original variable names for
  \code{descriptors} with converted variable names correspondingly
  named.}
}
}
\description{
Converts a data frame into a MD-PMS Device Event data frame.
}
\examples{
# A barebones dataset
de <- deviceevent(maude, "date_received", "device_name", "event_type")
# With more variables and variable types
de <- deviceevent(
  data_frame=maude,
  time="date_received",
  device_hierarchy=c("device_name", "device_class"),
  event_hierarchy=c("event_type", "medical_specialty_description"),
  key="report_number",
  covariates=c("region"),
  descriptors="_all_")

}
