% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcpnn.R
\name{bcpnn}
\alias{bcpnn}
\alias{bcpnn.mds_ts}
\alias{bcpnn.default}
\title{Bayesian Confidence Propagation Neural Network}
\usage{
bcpnn(df, ...)

\method{bcpnn}{mds_ts}(df, ts_event = c(Count = "nA"), analysis_of = NA, ...)

\method{bcpnn}{default}(
  df,
  analysis_of = NA,
  eval_period = 1,
  null_ratio = 1,
  conf_interval = 0.9,
  quantiles = c(0.05, 0.95),
  cont_adj = 0,
  ...
)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{nA}{Cell A count (class \code{numeric}) of the 2x2 table:
  device/event of interest.}
  \item{nB}{Cell B count (class \code{numeric}) of the 2x2 table:
  device/non-event of interest.}
  \item{nC}{Cell C count (class \code{numeric}) of the 2x2 table:
  non-device/event of interest.}
  \item{nD}{Cell D count (class \code{numeric}) of the 2x2 table:
  non-device/non-event of interest.}
}}

\item{...}{Further arguments passed onto \code{bcpnn} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count (cell A in the 2x2
contingency table). In most cases, the default is the appropriate setting.
See details for alternative options.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Count of bone cement leakages"}}

\item{eval_period}{Required positive integer indicating the number of unique
times counting in reverse chronological order to sum over to create the 2x2
contingency table.

Default: \code{1} considers only the most recent time in \code{df}.

Example: \code{12} sums over the last 12 time periods to create the 2x2
contingency table.}

\item{null_ratio}{Numeric value representing the null relative reporting
ratio (RR), used with \code{conf_interval} to establish the signal status.
This \code{null_ratio} is saved in the output as the signal threshold. See
details for more.

Default: \code{1} indicates a null RR of 1 and tests if the lower bound of
the IC \code{conf_interval} exceeds \code{1}.}

\item{conf_interval}{Numeric value between 0 and 1 representing the width of
the IC confidence interval, where the lower bound of the
interval is assessed against the \code{null_ratio}. The interval bounds are
returned as the lcl and ucl. See details for more.

Default: \code{0.90} indicates a 90\% confidence interval with bounds at 5\%
and 95\%. The signal test is against the lower 5\% bound, effectively
creating a one-sided test at the conventional 0.05 alpha level.}

\item{quantiles}{Vector of quantiles between 0 and 1. \code{bcpnn()} will
return an equal length vector of Gaussian-approximated quantiles from the
posterior distribution of the IC. Specify \code{quantiles=NULL} if no
quantiles are desired.

Default: \code{c(.05, .95)} corresponds to the 5\% and 95\% quantiles of the
IC.}

\item{cont_adj}{Non-negative number representing the continuity
adjustment to be added to each cell of the 2x2 contingency table. A value
greater than 0 allows for contingency tables with a 0 in the D cell to run
the algorithm. Adding a continuity adjustment will adversely affect the
algorithm estimates, user discretion is advised. See details for more.

Default: \code{0} adds zero to each cell, thus an unadjusted table.}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the set
  confidence bounds, \code{p} for the p-value, \code{signal} status, and
  \code{signal_threshold}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using a one-layer BCPNN as proposed by Bate et al
(1998), which assumes beta-distributed probabilities and a normal
approximation of the variance of the information component (IC). From
the family of disproportionality analyses (DPA) used to generate signals of
disproportionate reporting (SDRs).
}
\details{
\code{null_ratio} and \code{conf_interval} are used together to establish the
signal criteria. The \code{null_ratio} is conceptually similar to the
relative reporting ratio under a null hypothesis of no signal. Common values
are \code{1} and, more conservatively (fewer false signals), \code{2}. The
\code{conf_interval} is the IC confidence interval used to test for a
signal. A value of \code{0.90} returns the 5% and 95% confidence bounds and
tests if the lower bound exceeds \code{null_ratio}. Effectively,
\code{conf_interval=0.90} conducts a one-sided test at the conventional 0.05
alpha level.

\code{cont_adj} provides the option to allow \code{bcpnn()} to proceed running,
however this is done at the user's discretion because there are adverse
effects of adding a positive number to every cell of the contingency table.
By default, \code{bcpnn()} allows 0 in all cells except D.
It has been suggested that 0.5 may be an appropriate value. However, the
user is cautioned that interpretation may be compromised by adding continuity
adjustments.

For parameter \code{ts_event}, in the uncommon case where the
device-event count (Cell A) variable is not \code{"nA"}, the name of the
variable may be specified here. Note that the remaining 3 cells of the 2x2
contingency table (Cells B, C, D) must be the variables \code{"nB"},
\code{"nC"}, and \code{"nD"} respectively in \code{df}. A named character
vector may be used where the name is the English description of what was
analyzed. Note that if the parameter \code{analysis_of} is specified, it will
override this name. Example: \code{ts_event=c("Count of Bone Cement
Leakages"="event_count")}
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: BCPNN on mds_ts data

\item \code{default}: BCPNN on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:25),
                   nA=as.integer(stats::rnorm(25, 25, 5)),
                   nB=as.integer(stats::rnorm(25, 50, 5)),
                   nC=as.integer(stats::rnorm(25, 100, 25)),
                   nD=as.integer(stats::rnorm(25, 200, 25)))
a1 <- bcpnn(data)
# Example using an mds_ts object
a2 <- bcpnn(mds_ts[[3]])

}
\references{
Bate A, Lindquist M, et al. A Bayesian Neural Network Method for Adverse Drug Reaction Signal Generation. European Journal of Clinical Pharmacology, 1998, 54, 315-321.

Ahmed I, Poncet A. PhViD: PharmacoVigilance Signal Detection, 2016. R package version 1.0.8.

Lansner A, Ekeberg Ö. A one-layer feedback artificial neural network with a bayesian learning rule. Int. J. Neural Syst., 1989, 1, 77-87.
}
