% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvthemes.R
\name{md_theme_avatar}
\alias{md_theme_avatar}
\alias{md_theme_brooklyn99}
\alias{md_theme_hildaDay}
\alias{md_theme_hildaDusk}
\alias{md_theme_hildaNight}
\alias{md_theme_parksAndRec}
\alias{md_theme_parksAndRec_light}
\alias{md_theme_parksAndRecLight}
\alias{md_theme_rickAndMorty}
\alias{md_theme_simpsons}
\alias{md_theme_spongeBob}
\alias{md_theme_theLastAirbender}
\title{tvthemes Markdown Themes}
\usage{
md_theme_avatar(...)

md_theme_brooklyn99(...)

md_theme_hildaDay(...)

md_theme_hildaDusk(...)

md_theme_hildaNight(...)

md_theme_parksAndRec(...)

md_theme_parksAndRec_light(...)

md_theme_parksAndRecLight(...)

md_theme_rickAndMorty(...)

md_theme_simpsons(...)

md_theme_spongeBob(...)

md_theme_theLastAirbender(...)
}
\arguments{
\item{...}{Arguments passed on to the corresponding theme in package \code{{tvthemes}}}
}
\value{
An object of class \code{theme} that can be added to any \code{ggplot}
}
\description{
\code{{tvthemes}} themes supporting markdown syntax
}
\examples{
library(ggplot2)
data(mtcars)

p <- ggplot(mtcars, aes(hp, mpg)) +
  geom_point() +
  labs(
    title = "A **bold** title",
    subtitle = "An *italics* subtitle",
    caption = "A <span style = 'color:blue'>blue</span> caption"
  )

# With a 'usual' theme the text is not rendered
p

# By adding an 'md' theme the text is rendered properly
p + md_theme_simpsons()

}
\seealso{
\code{\link[=as_md_theme]{as_md_theme()}}
}
